/* DataProcessor02.cc */
/* Sample program to access data descriptor object */


#include <iostream>
#include <iomanip>
#include "MushArgumentList.hh"
#include "KinokoDataSource.hh"
#include "KinokoDataSection.hh"
#include "KinokoDataProcessor.hh"
#include "KinokoStandaloneComponent.hh"


using namespace std;


class TMyDataConsumer: public TKinokoDataConsumer {
  public:
    TMyDataConsumer(string DataSourceName, string SectionName);
    virtual ~TMyDataConsumer();
    virtual void OnRunBegin(void) throw(TKinokoException);
    virtual void OnReceiveDataPacket(void* DataPacket, long PacketSize) throw(TKinokoException);
  protected:
    string _DataSourceName, _SectionName;
    int _DataSourceId, _SectionId;
};



TMyDataConsumer::TMyDataConsumer(string DataSourceName, string SectionName)
{
    _DataSourceName = DataSourceName;
    _SectionName = SectionName;

    _DataSourceId = -1;
    _SectionId = -1;
}

TMyDataConsumer::~TMyDataConsumer()
{
}

void TMyDataConsumer::OnRunBegin(void) throw(TKinokoException)
{
    // get DataSource object by name//
    TKinokoDataSource* DataSource = _InputDataDescriptor->DataSource(_DataSourceName);

    if (DataSource != 0) {
	// get DataSourceId //
	_DataSourceId = DataSource->DataSourceId();

	// get DataSection object by name //
	TKinokoDataSection* DataSection = DataSource->DataSection(_SectionName);

	if (DataSection != 0) {
	    // get SectionId //
	    _SectionId = DataSection->SectionId();
	}
    }
}

void TMyDataConsumer::OnReceiveDataPacket(void* DataPacket, long PacketSize) throw(TKinokoException)
{
    // get DataSourceId //
    int DataSourceId = TKinokoDataStreamScanner::DataSourceIdOf(DataPacket);
    if (DataSourceId != _DataSourceId) {
	return;
    }

    int SectionId = TKinokoDataSectionScanner::SectionIdOf(DataPacket);
    if (SectionId != _SectionId) {
	return;
    }

    // get data and data size //
    void* Data = TKinokoDataSectionScanner::DataAreaOf(DataPacket);
    size_t DataSize = TKinokoDataSectionScanner::DataSizeOf(DataPacket);

    // hexadecimal dump //
    cout << "[" << DataSourceId << ":" << SectionId << "]";
    cout << hex << setfill('0');
    for (unsigned Offset = 0; Offset < DataSize; Offset++) {
	if (Offset % 16 == 0) {
	    cout << endl;
	    cout << setw(4) << Offset << ":  ";
	}
	else if (Offset % 8 == 0) {
	    cout << " ";
	}	
	cout << setw(2) << (int) ((unsigned char*) Data)[Offset] << " ";
    }
    cout << dec << setfill(' ') << endl;
}


int main(int argc, char** argv)
{
    TMushArgumentList ArgumentList(argc, argv);

    TMyDataConsumer MyDataConsumer("CamacAdc", "adc");
    TKinokoStandaloneDataConsumer StandaloneDataConsumer(&MyDataConsumer, "MyDataConsumer");

    try {
	StandaloneDataConsumer.Start(ArgumentList);
    }
    catch (TKinokoException &e) {
	cerr << "ERROR: " << e << endl;
    }

    return 0;
}
