#include <iostream>
#include <sstream>
#include <string>
#include <cstdio>
#include <cstdlib>

using namespace std;

string InputFileName = "test01.kdf";
static const int MaxLineLength = 1024;

int main(void)
{
    string Command = "kdftable " + InputFileName;
    FILE* InputFile = popen(Command.c_str(), "r");
    if (InputFile == NULL) {
	cerr << "ERROR: unable to execute command: " << Command;
	exit(EXIT_FAILURE);
    }
    
    char Line[MaxLineLength];
    int EventIndex, Time, FieldIndex, Data;

    while (fgets(Line, sizeof(Line), InputFile) != NULL) {
        if ((Line[0] == '\n') || (Line[0] == '#')) {
            continue;
        }

	istringstream Stream(Line);
	Stream >> EventIndex >> Time;
	cout << EventIndex << " " << Time << ":  ";
	for (FieldIndex = 0; Stream >> Data; FieldIndex++) {
	    cout << FieldIndex << "-" << Data << ",  ";
	}
	cout << endl;
    }

    pclose(InputFile);

    return 0;
}
