/* MoguraEventPiece.hh */
/* Created by Enomoto Sanshiro on 13 August 2009. */
/* Last updated by Enomoto Sanshiro on 11 March 2009. */


#include <iostream>
#include <map>
#include "KinokoEventChopper.hh"
#include "KinokoEventSorter.hh"


class TMoguraEventPieceScanner: public TKinokoEventPieceScanner {
  public:
    TMoguraEventPieceScanner(void);
    virtual ~TMoguraEventPieceScanner();
    virtual int MaximumPieceSize(void);
    virtual int Scan(TStreamKey StreamKey, TKinokoEventPiece& EventPiece);
  protected:
    virtual int ScanFirstDataFrame(int CardNnumber, TKinokoEventPiece& EventPiece);
    virtual int ScanTestPattern(int CardNumber, TKinokoEventPiece& EventPiece);
    virtual int ScanCorrupted(int CardNumber, TKinokoEventPiece& EventPiece);
  protected:
    std::map<int, int> _LastPieceTypeTable;
};
