/* SoftwareModule-test.cc */
/* Created by Enomoto Sanshiro on 14 May 2008 */ 
/* Last Updated by Enomoto Sanshiro on 14 May 2008 */ 


#include <iostream>
#include <cstdlib>
#include "RoomDeviceFactory.hh"

using namespace std;


static const char* DeviceName = "DevRandom";
static const int NumberOfEvents = 10;


int main(void)
{
    TRoomSoftwareModule* Module = 0;
    TRoomDeviceFactory* DeviceFactory;

    try {
	DeviceFactory = TRoomDeviceFactory::GetInstance();
	Module = DeviceFactory->CreateSoftwareModule(DeviceName);

	int Channel, Data;
	int NumberOfChannels = Module->NumberOfChannels();

	Module->Initialize();

	for (int i = 0; i < NumberOfEvents; i++) {
	    Module->WaitData();

	    for (Channel = 0; Channel < NumberOfChannels; Channel++) {
		if (Module->Read(Channel, Data) > 0) {
		    cout << i << " " << Channel << " " << Data << endl;
		}
	    }

	    Module->Clear();
	}

	Module->Finalize();
    }
    catch (THardwareException &e) {
	delete Module;
	cerr << "ERROR: " << e << endl;
	exit(EXIT_FAILURE);
    }

    delete Module;

    return 0;
}
