/* module-DevRandom.cc */
/* Created by Enomoto Sanshiro on 14 May 2008 */ 
/* Last Updated by Enomoto Sanshiro on 14 May 2008 */ 


#include <cstdlib>
#include <cstring>
#include <cerrno>
#include <fcntl.h>
#include <poll.h>
#include "RoomSoftwareDevice.hh"
#include "RoomDeviceFactory.hh"
#include "module-DevRandom.hh"

using namespace std;


static TRoomSoftwareModuleCreator Creator(
    "DevRandom", new TSoftwareModule_DevRandom()
);


TSoftwareModule_DevRandom::TSoftwareModule_DevRandom(void)
: TRoomSoftwareModule("DevRandom", "Software_DevRandom")
{
    _DeviceFile = -1;
}

TSoftwareModule_DevRandom::~TSoftwareModule_DevRandom()
{
}
    
TRoomSoftwareModule* TSoftwareModule_DevRandom::Clone(void)
{
    return new TSoftwareModule_DevRandom();
}

int TSoftwareModule_DevRandom::NumberOfChannels(void) throw(THardwareException)
{
    return 16;
}

int TSoftwareModule_DevRandom::AddressBitLength(void)
{
    return 4;
}

int TSoftwareModule_DevRandom::DataBitLength(void)
{
    return 16;
}

int TSoftwareModule_DevRandom::Initialize(int InitialState) throw(THardwareException)
{
    _DeviceFile = open("/dev/random", O_RDONLY);
    if (_DeviceFile < 0) {
	throw THardwareException(
	    "TSoftwareModule_DevRandom::Initialize()",
	    "unable to open file: /dev/random"
	);
    }

    return 0;
}

int TSoftwareModule_DevRandom::Finalize(int FinalState) throw(THardwareException)
{
    if (_DeviceFile >= 0) {
	close(_DeviceFile);
	_DeviceFile = -1;
    }
    
    return 0;
}

int TSoftwareModule_DevRandom::Clear(int Address) throw(THardwareException)
{
    return 0;
}

bool TSoftwareModule_DevRandom::HasData(int Address) throw(THardwareException)
{
    struct pollfd fds;
    fds.fd = _DeviceFile;
    fds.events = POLLIN;

    if (poll(&fds, 1, 0) < 0) {
	throw THardwareException(
	    "TSoftwareModule_DevRandom::HasData()", strerror(errno)
	);
    }

    return fds.revents & POLLIN;
}

int TSoftwareModule_DevRandom::Read(int Address, int &Data) throw(THardwareException)
{
    U16bit Buffer;

    int Result = read(_DeviceFile, &Buffer, sizeof(Buffer));
    if (Result < 0) {
	if (errno == EINTR) {
	    // interrupted. retry.
	    return this->Read(Address, Data);
	}
	else {
	    throw THardwareException(
		"TSoftwareModule_DevRandom::Read()", strerror(errno)
	    );
	}
    }

    Data = Buffer;

    return Result;
}
