/* benchbuffer.cc */
/* Buffer Manager for Benchmark test */
/* Created by Enomoto Sanshiro on 20 April 1998. */
/* Last updated by Enomoto Sanshiro on 8 January 2000. */


#include <iostream>
#include <cstdlib>
#include "MushTimer.hh"
#include "KinokoBufferServer.hh"
#include "KinokoBufferClient.hh"

using namespace std;


#define SharedMemoryProjectID 100
#define MessageQueueProjectID 101
#define BufferSize (256 * 1024)
#define BufferEntryTableSize 256


class TBufferManager {
  public:
    TBufferManager(void) throw(TKinokoException);
    virtual ~TBufferManager();
    virtual void Start(void) throw(TKinokoException);
  protected:
    virtual void AttachService(TMushIntervalTimer *TimeKeeper) throw(TKinokoException);
    virtual int DoTransaction(TMushIntervalTimer *TimeKeeper) throw(TKinokoException);
  private:
    TKinokoBufferServer *_KinokoBufferServer;
    TKinokoBufferLogger* _BufferLogger;
};


TBufferManager::TBufferManager(void) throw(TKinokoException)
{
    _KinokoBufferServer = 0;
    _BufferLogger = new TKinokoBufferStreamLogger(cerr);
}

TBufferManager::~TBufferManager()
{
    delete _KinokoBufferServer;
    delete _BufferLogger;
}

void TBufferManager::Start(void) throw(TKinokoException)
{
    TMushIntervalTimer *TimeKeeper = new TMushRealTimeTimer(1, 0);
    TMushSignalHandler *SignalHandler = new TMushSignalHandler();
    TMushSignalCounter *SignalCounter = new TMushSignalCounter();
    SignalHandler->RegisterClient(SIGINT, SignalCounter);
    SignalHandler->RegisterClient(SIGTERM, SignalCounter);
    SignalHandler->StartHandling();

    AttachService(TimeKeeper);

    while (SignalCounter->SignalCount() == 0) {
	DoTransaction(TimeKeeper);
    }

    delete SignalCounter;
    delete SignalHandler;
    delete TimeKeeper;
}

void TBufferManager::AttachService(TMushIntervalTimer *TimeKeeper) throw(TKinokoException) 
{
    _KinokoBufferServer = new TKinokoBufferServer(
        SharedMemoryProjectID, MessageQueueProjectID, 
        BufferSize, BufferEntryTableSize,
	_BufferLogger
    );
}

int TBufferManager::DoTransaction(TMushIntervalTimer *TimeKeeper) throw(TKinokoException)
{
    try {
        return _KinokoBufferServer->DoTransaction(TimeKeeper);
    }
    catch (TSystemCallException &e) {
        throw TKinokoException("System Call Exception: " + e.Message());
    }
    catch (TKinokoException &e) {
        throw;
    }
}


int main(int argc, char **argv)
{
    try {
	TBufferManager().Start();
    }
    catch (TKinokoException &e) {
	cerr << "ERROR: " << argv[0] << ": " << e << endl;
    }

    return 0;
}
