/* filebench-fixedsize.cc */
/* Created by Enomoto Sanshiro on 25 April 2002. */
/* Last updated by Enomoto Sanshiro on 25 April 2002. */


#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <cstring>
#include "MushFile.hh"
#include "MushTimer.hh"
#include "MushMisc.hh"
#include "KinokoDefs.hh"

using namespace std;


void Write(TMushFile *File, int PacketSize, int NumberOfTrials) throw(TKinokoException)
{
    TMushDateTime StartTime, StopTime;

    char* Buffer = new char[PacketSize];
    long NumberOfPackets = 1;
    double GrandTotalTime = 0;
    double GrandTotalSize = 0;

    for (int i = 0; i < NumberOfTrials; i++) {
	double TransferSize = PacketSize * NumberOfPackets;

	StartTime.Update();
	File->Write(Buffer, PacketSize);
	StopTime.Update();
	
	double TransferTime = (
            (StopTime.AsLong() - StartTime.AsLong()) + 
            (StopTime.USec() - StartTime.USec()) * 1e-6
        );
	double Speed = TransferSize / TransferTime;
	double PacketTime = TransferTime / NumberOfPackets;

	GrandTotalTime += TransferTime;
	GrandTotalSize += PacketSize;
	
#if 0
	cerr << "total size = " << (TransferSize / 1024 / 1024) << " [MB]" << endl;
	cerr << "# of packets = " << NumberOfPackets << endl;
	cerr << "packet size = " << (PacketSize / 1024) << " [kB]" << endl;
	cerr << "packet time = " << (PacketTime * 1e+3) << " [msec]" << endl;
	cerr << "total time = " << TotalTime << " [sec]" << endl;
	cerr << "speed = " << (Speed / 1024.0 / 1024.0) << " [MB/sec]" << endl;
	cerr << endl;
#else
	cerr << '.' << flush;
#endif

	cout << (PacketSize / 1024.0) << "\t";
        cout << (PacketTime * 1.0e+3) << "\t";
	cout << TransferTime << "\t";
        cout << (Speed / 1024.0 / 1024.0)  << "\t";
	cout << endl; 
    }

    cerr << endl;
    cerr << "grand total size: " << GrandTotalSize / 1024 / 1024 << " [MB] " << endl;
    cerr << "grand total time: " << GrandTotalTime << " [sec] " << endl;
    cerr << "avarage speed: " << GrandTotalSize / 1024.0 / 1024.0 / GrandTotalTime << " [MB/sec] " << endl;
    cerr << endl;
}


int main(int argc, char **argv)
{
    if (argc < 4) {
	cerr << "Usage: filebench FileName PacketSize NumberOfTrials" << endl;
	return -1;
    }

    char *FileName = argv[1];
    int PacketSize = atol(argv[2]);
    int NumberOfTrials = atol(argv[3]);

    try {
	TMushFile* File = new TMushFile(FileName);
	File->OpenWriteMode();
	Write(File, PacketSize, NumberOfTrials);
	File->Close();
	delete File;
    }
    catch (TSystemCallException &e) {
        cerr << e << endl;
    }

    return 0;
}
