/* filebench.cc */
/* Created by Enomoto Sanshiro on 25 April 2002. */
/* Last updated by Enomoto Sanshiro on 25 April 2002. */


#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <cstring>
#include "MushFile.hh"
#include "MushTimer.hh"
#include "MushMisc.hh"
#include "KinokoDefs.hh"

using namespace std;


const static long TotalSize = 512 * 1024;
const static size_t BufferSize = 256 * 1024;
static char Buffer[BufferSize];


void Write(TMushFile *File) throw(TKinokoException)
{
    TMushDateTime StartTime, StopTime;

    for (unsigned long PacketSize = 1024; PacketSize < BufferSize; PacketSize += 2 * 1024) {
	long NumberOfPackets = TotalSize / PacketSize;
	double TransferSize = PacketSize * NumberOfPackets;

	StartTime.Update();
	for (int i = 0; i < NumberOfPackets; i++) {
	    File->Write(Buffer, PacketSize);
	}
	StopTime.Update();
	
	double TransferTime = (
            (StopTime.AsLong() - StartTime.AsLong()) + 
            (StopTime.USec() - StartTime.USec()) * 1e-6
        );
	double Speed = TransferSize / TransferTime;
	double PacketTime = TransferTime / NumberOfPackets;
	
#if 0
	cerr << "total size = " << (TransferSize / 1024 / 1024) << " [MB]" << endl;
	cerr << "# of packets = " << NumberOfPackets << endl;
	cerr << "packet size = " << (PacketSize / 1024) << " [kB]" << endl;
	cerr << "packet time = " << (PacketTime * 1e+3) << " [msec]" << endl;
	cerr << "total time = " << TotalTime << " [sec]" << endl;
	cerr << "speed = " << (Speed / 1024.0 / 1024.0) << " [MB/sec]" << endl;
	cerr << endl;
#else
	cerr << '.' << flush;
#endif

	cout << (PacketSize / 1024) << "\t";
        cout << (PacketTime * 1e+3) << "\t";
	cout << TransferTime << "\t";
        cout << (Speed / 1024.0 / 1024.0)  << "\t";
	cout << endl; 
    }

    cerr << endl;
}


int main(int argc, char **argv)
{
    if (argc < 2) {
	cerr << "Usage: filebench FileName" << endl;
	return -1;
    }
    char *FileName = argv[1];

    try {
	TMushFile* File = new TMushFile(FileName);
	File->OpenWriteMode();
	Write(File);
	File->Close();
	delete File;
    }
    catch (TSystemCallException &e) {
        cerr << e << endl;
    }

    return 0;
}
