/* KameHistogram2d.hh */
/* Created by Enomoto Sanshiro on 13 January 2001. */
/* Last updated by Enomoto Sanshiro on 9 July 2009. */


#ifndef __KameHistogram2d_hh__
#define __KameHistogram2d_hh__


#include <string>
#include "KameObject.hh"
#include "KameHistogram.hh"
#include "KameGraph.hh"


namespace kame {

class TKameHistogram2d: public TKameObject {
  public:
    TKameHistogram2d(void);
    TKameHistogram2d(const TKameHistogram2d& Histogram2d);
    TKameHistogram2d(const TKameHistogramScale& XScale, const TKameHistogramScale& YScale);
    virtual ~TKameHistogram2d();
    virtual TKameHistogram2d& operator=(const TKameHistogram2d& Histogram2d);
  public:
    void SetScale(const TKameHistogramScale& XScale, const TKameHistogramScale& YScale);
    void Clear(void);
    bool HasData(void);
  public:
    inline void Fill(double DataX, double DataY, double Weight = 1.0);
    inline TKameHistogramScale& XScale(void);
    inline TKameHistogramScale& YScale(void);
    inline const TKameHistogramScale& XScale(void) const;
    inline const TKameHistogramScale& YScale(void) const;
    inline long NumberOfEntries(void) const;
    inline double PeakCounts(void) const;
    inline double CountsOf(int BinNumberX, int BinNumberY) const;
  public:
    TKameGraph* MakeContour(double Threshold, std::string Title = "");
  protected:
    TKameHistogramScale _XScale, _YScale;
    double* _Storage;
    double _PeakCounts;
    long _NumberOfEntries;
    int _NumberOfXBins, _NumberOfYBins;
};



inline void TKameHistogram2d::Fill(double DataX, double DataY, double Weight)
{
    if ((DataX < _XScale.Min()) || (DataX >= _XScale.Max())) {
	;
    }
    else if ((DataY < _YScale.Min()) || (DataY >= _YScale.Max())) {
	;
    }
    else {
	int Index = (
	    _YScale.BinNumberOf(DataY) * _NumberOfXBins + 
	    _XScale.BinNumberOf(DataX)
	);

	double Counts = (_Storage[Index] += Weight);
	if (Counts > _PeakCounts) {
	     _PeakCounts = Counts;
	}

	_NumberOfEntries++;
    }
}

inline TKameHistogramScale& TKameHistogram2d::XScale(void)
{
    return _XScale;
}

inline TKameHistogramScale& TKameHistogram2d::YScale(void)
{
    return _YScale;
}

inline const TKameHistogramScale& TKameHistogram2d::XScale(void) const
{
    return _XScale;
}

inline const TKameHistogramScale& TKameHistogram2d::YScale(void) const
{
    return _YScale;
}

inline double TKameHistogram2d::CountsOf(int BinNumberX, int BinNumberY) const
{
    return _Storage[BinNumberY * _NumberOfXBins + BinNumberX];
}

inline long TKameHistogram2d::NumberOfEntries(void) const
{
    return _NumberOfEntries;
}

inline double TKameHistogram2d::PeakCounts(void) const
{
    return _PeakCounts;
}

}
#endif
