/* KameHistory.hh */
/* Created by Enomoto Sanshiro on 29 October 1999. */
/* Last updated by Enomoto Sanshiro on 29 June 2002. */


/************************************************/
/* DEPRECIATED: DO NOT USE                      */
/* THIS CODE WILL BE REMOVED IN FUTURE RELEASE  */
/************************************************/


#ifndef __KameHistory_hh__
#define __KameHistory_hh__


#include <string>
#include "KameObject.hh"


namespace kame {

class TKameHistory: public TKameObject {
  public:
    TKameHistory(void);
    explicit TKameHistory(long MaxNumberOfSamples);
    ~TKameHistory();
  private:
    // do not copy this object //
    TKameHistory(const TKameHistory& History) {}
    TKameHistory& operator=(const TKameHistory& History) { return *this; }
  public:
    void SetScale(long MaxNumberOfSamples);
    void Clear(void);
    bool HasData(void) const;
  public:
    void Start(long CurrentTime);
    void HoldSample(long TimeStamp = 0);
    void InsertSample(long Time, long Counts, double Sum, double Mean, double Deviation);
  public:
    inline void Fill(double Data, long TimeStamp = 0);
    inline long MaxNumberOfSamples(void) const;
    inline long NumberOfSamples(void) const;
    inline long StartTime(void) const;
    inline long TimeOf(long SampleIndex) const;
    inline long PassedTimeOf(long SampleIndex) const;
    inline long CountsOf(long SampleIndex) const;
    inline double SumOf(long SampleIndex) const;
    inline double MeanOf(long SampleIndex) const;
    inline double DeviationOf(long SampleIndex) const;
    inline long LastTime(void) const;
    inline long LastPassedTime(void) const;
    inline long LastCounts(void) const;
    inline double LastSum(void) const;
    inline double LastMean(void) const;
    inline double LastDeviation(void) const;
  protected:
    long _MaxNumberOfSamples;
    long _NumberOfSamples;
    long _BaseIndex;
    long _StartTime;
    long _LastDataTime;
    long* _TimeStorage;
    long* _CountStorage;
    double* _SumStorage;
    double* _MeanStorage;
    double* _DeviationStorage;
  private:
    long _CurrentCounts;
    double _CurrentSum;
    double _CurrentSumOfSquared;
};


inline void TKameHistory::Fill(double Data, long TimeStamp)
{
    _CurrentSum += Data;
    _CurrentSumOfSquared += Data * Data;
    _CurrentCounts++;

    _LastDataTime = TimeStamp;
}

inline long TKameHistory::MaxNumberOfSamples(void) const
{
    return _MaxNumberOfSamples;
}

inline long TKameHistory::NumberOfSamples(void) const
{
    return _NumberOfSamples;
}

inline long TKameHistory::StartTime(void) const
{
    return _StartTime;
}

inline long TKameHistory::TimeOf(long SampleIndex) const
{
    return _TimeStorage[(_BaseIndex + SampleIndex) % _MaxNumberOfSamples];
}

inline long TKameHistory::PassedTimeOf(long SampleIndex) const
{
    return _TimeStorage[(_BaseIndex + SampleIndex) % _MaxNumberOfSamples] - _StartTime;
}

inline double TKameHistory::SumOf(long SampleIndex) const
{
    return _SumStorage[(_BaseIndex + SampleIndex) % _MaxNumberOfSamples];
}

inline double TKameHistory::MeanOf(long SampleIndex) const
{
    return _MeanStorage[(_BaseIndex + SampleIndex) % _MaxNumberOfSamples];
}

inline double TKameHistory::DeviationOf(long SampleIndex) const
{
    return _DeviationStorage[(_BaseIndex + SampleIndex) % _MaxNumberOfSamples];
}

inline long TKameHistory::CountsOf(long SampleIndex) const
{
    return _CountStorage[(_BaseIndex + SampleIndex) % _MaxNumberOfSamples];
}

inline long TKameHistory::LastTime(void) const
{
    return _TimeStorage[(_BaseIndex + _NumberOfSamples - 1) % _MaxNumberOfSamples];
}

inline long TKameHistory::LastPassedTime(void) const
{
    return _TimeStorage[(_BaseIndex + _NumberOfSamples - 1) % _MaxNumberOfSamples] - _StartTime;
}

inline long TKameHistory::LastCounts(void) const
{
    return _CountStorage[(_BaseIndex + _NumberOfSamples - 1) % _MaxNumberOfSamples];
}

inline double TKameHistory::LastSum(void) const
{
    return _SumStorage[(_BaseIndex + _NumberOfSamples - 1) % _MaxNumberOfSamples];
}

inline double TKameHistory::LastMean(void) const
{
    return _MeanStorage[(_BaseIndex + _NumberOfSamples - 1) % _MaxNumberOfSamples];
}

inline double TKameHistory::LastDeviation(void) const
{
    return _DeviationStorage[(_BaseIndex + _NumberOfSamples - 1) % _MaxNumberOfSamples];
}


}
#endif
