/* KameNtuple.hh */
/* Created by Enomoto Sanshiro on 29 June 2009. */
/* Last updated by Enomoto Sanshiro on 29 June 2009. */


#ifndef __KameNtuple_hh__
#define __KameNtuple_hh__


#include <string>
#include <vector>
#include <map>
#include "KameDefs.hh"
#include "KameObject.hh"
#include "KameTable.hh"


namespace kame {


class TKameNtuple: public TKameObject, public TKameTable {
  public:
    TKameNtuple(void);
    TKameNtuple(const TKameNtuple& Ntuple);
    explicit TKameNtuple(unsigned NumberOfColumns);
    virtual ~TKameNtuple();
    virtual TKameNtuple& operator=(const TKameNtuple& Ntuple);
  public:
    virtual void SetColumnNameType(unsigned ColumnIndex, const std::string& ColumnName, const std::string& ColumnType);
    virtual const std::string& ColumnTypeOf(unsigned ColumnIndex) const throw(TKameException);
    virtual bool HasTypeList(void) const;
    virtual void BreakSegment(void);
    virtual unsigned NumberOfSegments(void) const;
    virtual unsigned SegmentIndexOf(unsigned RowIndex) const;
  private:
    mutable std::map<unsigned, std::string> _ColumnIndexTypeTable;
    std::vector<unsigned> _SegmentBoundaryList;
    bool _HasTypeList;
    mutable unsigned _LastRowIndex, _LastSegmentIndex;
};


}
#endif
