/* KameRepository.hh */
/* Created by Enomoto Sanshiro on 1 July 2009. */
/* Last updated by Enomoto Sanshiro on 1 July 2009. */


#ifndef __KameRepository_hh__
#define __KameRepository_hh__


#include <string>
#include "KameDefs.hh"
#include "KameNtuple.hh"
#include "KameGraph.hh"
#include "KameHistogram.hh"
#include "KameHistogram2d.hh"
#include "KameTrend.hh"
#include "KameHistory.hh"


namespace kame {


class TKameRepository {
  public:
    TKameRepository(void) {}
    virtual ~TKameRepository() {}
    virtual void SaveNtuple(const TKameNtuple& Ntuple, const std::string& Name) throw(TKameException) = 0;
    virtual void LoadNtuple(TKameNtuple& Ntuple, const std::string& Name, int Revision=-1) throw(TKameException) = 0;
  public:
    virtual void SaveGraph(const TKameGraph& Graph, const std::string& Name) throw(TKameException);
    virtual void LoadGraph(TKameGraph& Graph, const std::string& Name, int Revision=-1) throw(TKameException);
    virtual void SaveHistogram(const TKameHistogram& Histogram, const std::string& Name) throw(TKameException);
    virtual void LoadHistogram(TKameHistogram& Histogram, const std::string& Name, int Revision=-1) throw(TKameException);
    virtual void SaveHistogram2d(const TKameHistogram2d& Histogram, const std::string& Name) throw(TKameException);
    virtual void LoadHistogram2d(TKameHistogram2d& Histogram, const std::string& Name, int Revision=-1) throw(TKameException);
    virtual void SaveTrend(const TKameTrend& Trend, const std::string& Name) throw(TKameException);
    virtual void LoadTrend(TKameTrend& Trend, const std::string& Name, int Revision=-1) throw(TKameException);
    virtual void SaveHistory(const TKameHistory& History, const std::string& Name) throw(TKameException);
    virtual void LoadHistory(TKameHistory& History, const std::string& Name, int Revision=-1) throw(TKameException);
};



}
#endif
