/* KameRepository.cc */
/* Created by Enomoto Sanshiro on 26 June 2002. */
/* Last updated by Enomoto Sanshiro on 9 July 2009. */


#include <string>
#include "KameRepository.hh"
#include "KamePlainTextRepository.hh"
#include "KameRootRepository.hh"
#include "KameRepositoryFactory.hh"

using namespace std;
using namespace kame;


TKameRepositoryFactory* TKameRepositoryFactory::_PlainTextRepositoryFactory = 0;
TKameRepositoryFactory* TKameRepositoryFactory::_RootRepositoryFactory = 0;


TKameRepositoryFactory::TKameRepositoryFactory(void)
{
}

TKameRepositoryFactory::~TKameRepositoryFactory()
{
}

TKameRepositoryFactory* TKameRepositoryFactory::GetInstance(const string& Type)
{
    if (Type == "PlainText") {
	if (_PlainTextRepositoryFactory == 0) {
	    _PlainTextRepositoryFactory = new TKamePlainTextRepositoryFactory();
	}
	return _PlainTextRepositoryFactory;
    }

    if ((Type == "root") || (Type == "Root") || (Type == "ROOT")) {
	if (_RootRepositoryFactory == 0) {
	    _RootRepositoryFactory = new TKameRootRepositoryFactory();
	}
	return _RootRepositoryFactory;
    }

    return 0;
}



TKamePlainTextRepositoryFactory::TKamePlainTextRepositoryFactory(void)
{
}

TKamePlainTextRepositoryFactory::~TKamePlainTextRepositoryFactory()
{
}

TKameRepository* TKamePlainTextRepositoryFactory::CreateRepository(const string& Name)
{
    return new TKamePlainTextRepository(Name);
}



TKameRootRepositoryFactory::TKameRootRepositoryFactory(void)
{
}

TKameRootRepositoryFactory::~TKameRootRepositoryFactory()
{
}

TKameRepository* TKameRootRepositoryFactory::CreateRepository(const string& Name)
{
#if IS_ROOT_AVAILABLE
    return new TKameRootRepository(Name);
#else
    return 0;
#endif
}
