/* KameRepository.hh */
/* Created by Enomoto Sanshiro on 26 June 2002. */
/* Last updated by Enomoto Sanshiro on 9 July 2009. */


#ifndef __KameRepositoryFactory_hh__
#define __KameRepositoryFactory_hh__


#include <string>
#include "KameRepository.hh"


namespace kame {


class TKameRepositoryFactory {
  protected:
    TKameRepositoryFactory(void);
  public:
    virtual ~TKameRepositoryFactory();
    static TKameRepositoryFactory* GetInstance(const std::string& Type);
    virtual TKameRepository* CreateRepository(const std::string& Name) = 0;
  private:
    static TKameRepositoryFactory* _PlainTextRepositoryFactory;
    static TKameRepositoryFactory* _RootRepositoryFactory;
};


class TKamePlainTextRepositoryFactory: public TKameRepositoryFactory {
  public:
    TKamePlainTextRepositoryFactory(void);
    virtual ~TKamePlainTextRepositoryFactory();
    virtual TKameRepository* CreateRepository(const std::string& Name);
};


class TKameRootRepositoryFactory: public TKameRepositoryFactory {
  public:
    TKameRootRepositoryFactory(void);
    virtual ~TKameRootRepositoryFactory();
    virtual TKameRepository* CreateRepository(const std::string& Name);
};


}
#endif
