/* KameTable.cc */
/* Created by Enomoto Sanshiro on 29 June 2009. */
/* Last updated by Enomoto Sanshiro on 29 June 2009. */


#include <string>
#include <sstream>
#include <iomanip>
#include <map>
#include "KameTable.hh"


using namespace std;
using namespace kame;


TKameTable::TKameTable(void)
{
    _NumberOfRows = 0;
}

TKameTable::TKameTable(const TKameTable& Table)
{
    if (this != &Table) {
	_NumberOfRows = Table._NumberOfRows;
	_Table = Table._Table;
	_ColumnIndexNameTable = Table._ColumnIndexNameTable;
	_ColumnNameIndexTable = Table._ColumnNameIndexTable;
    }
}

TKameTable::TKameTable(unsigned NumberOfColumns)
: _Table(NumberOfColumns)
{
    _NumberOfRows = 0;

    for (unsigned Index = 0; Index < NumberOfColumns; Index++) {
	ostringstream os;
	os << "Column" << setfill('0') << setw(2) << Index;
	SetColumnName(Index, os.str());
    }
}

TKameTable& TKameTable::operator=(const TKameTable& Table)
{
    if (this == &Table) {
	return *this;
    }

    _NumberOfRows = Table._NumberOfRows;
    _Table = Table._Table;
    _ColumnIndexNameTable = Table._ColumnIndexNameTable;
    _ColumnNameIndexTable = Table._ColumnNameIndexTable;

    return *this;
}

void TKameTable::Clear(void)
{
    for (unsigned i = 0; i < _Table.size(); i++) {
	_Table[i].erase(_Table[i].begin(), _Table[i].end());
    }
    _NumberOfRows = 0;
}

void TKameTable::SetColumnName(unsigned ColumnIndex, const std::string& ColumnName)
{
    _ColumnIndexNameTable[ColumnIndex] = ColumnName;
    _ColumnNameIndexTable[ColumnName] = ColumnIndex;
}

const std::string& TKameTable::ColumnNameOf(unsigned ColumnIndex) const throw(TKameException)
{
    return _ColumnIndexNameTable[ColumnIndex];
}

unsigned TKameTable::ColumnIndexOf(const std::string& ColumnName) const throw(TKameException)
{
    if (_ColumnNameIndexTable.count(ColumnName) == 0) {
	throw TKameException(
	    "TKameTable::ColumnIndexOf()", "bad column name"
	);
    }

    return _ColumnNameIndexTable[ColumnName];
}
