/* KameTrend.cc */
/* Created by Enomoto Sanshiro on 29 October 1999. */
/* Updated by Enomoto Sanshiro on 29 June 2002. */
/* Updated by Enomoto Sanshiro on 13 February 2008. */
/* Updated by Enomoto Sanshiro on 9 July 2009. */


#include <cmath>
#include <string>
#include "KameTrend.hh"

using namespace std;
using namespace kame;


TKameTrend::TKameTrend(void)
{
    _Interval = 1;
    _Length = 128;

    _Depth = (_Length / _Interval) + 1;

    _CountsStorage = new double[_Depth];
    _SumStorage = new double[_Depth];
    _SumOfSqrStorage = new double[_Depth];
    _MinValueStorage = new double[_Depth];
    _MaxValueStorage = new double[_Depth];

    Clear();
}

TKameTrend::TKameTrend(const TKameTrend& Trend)
{
    if (this == &Trend) {
	return;
    }

    _Depth = Trend._Depth;

    _CountsStorage = new double[_Depth];
    _SumStorage = new double[_Depth];
    _SumOfSqrStorage = new double[_Depth];
    _MinValueStorage = new double[_Depth];
    _MaxValueStorage = new double[_Depth];

    memcpy(_CountsStorage, Trend._CountsStorage, sizeof(double) * _Depth);
    memcpy(_SumStorage, Trend._SumStorage, sizeof(double) * _Depth);
    memcpy(_SumOfSqrStorage, Trend._SumOfSqrStorage, sizeof(double) * _Depth);
    memcpy(_MinValueStorage, Trend._MinValueStorage, sizeof(double) * _Depth);
    memcpy(_MaxValueStorage, Trend._MaxValueStorage, sizeof(double) * _Depth);

    _Interval = Trend._Interval;
    _Length = Trend._Length;
    _NumberOfPoints = Trend._NumberOfPoints;
    _BaseIndex = Trend._BaseIndex;
    _StartTime = Trend._StartTime;
    _MinTime = Trend._MinTime;
    _MaxTime = Trend._MaxTime;
}

TKameTrend::TKameTrend(long TickInterval, long WindowLength)
{
    _Interval = TickInterval;
    _Length = WindowLength;

    _Depth = (_Length / _Interval) + 1;

    _CountsStorage = new double[_Depth];
    _SumStorage = new double[_Depth];
    _SumOfSqrStorage = new double[_Depth];
    _MinValueStorage = new double[_Depth];
    _MaxValueStorage = new double[_Depth];

    Clear();
}

TKameTrend::~TKameTrend()
{
    delete[] _CountsStorage;
    delete[] _SumStorage;
    delete[] _SumOfSqrStorage;
    delete[] _MinValueStorage;
    delete[] _MaxValueStorage;
}

TKameTrend& TKameTrend::operator=(const TKameTrend& Trend)
{
    if (this == &Trend) {
	return *this;
    }

    if (_Depth != Trend._Depth) {
	_Depth = Trend._Depth;
	delete[] _CountsStorage;
	delete[] _SumStorage;
	delete[] _SumOfSqrStorage;
	delete[] _MinValueStorage;
	delete[] _MaxValueStorage;
	_CountsStorage = new double[_Depth];
	_SumStorage = new double[_Depth];
	_SumOfSqrStorage = new double[_Depth];
	_MinValueStorage = new double[_Depth];
	_MaxValueStorage = new double[_Depth];
    }

    memcpy(_CountsStorage, Trend._CountsStorage, sizeof(double) * _Depth);
    memcpy(_SumStorage, Trend._SumStorage, sizeof(double) * _Depth);
    memcpy(_SumOfSqrStorage, Trend._SumOfSqrStorage, sizeof(double) * _Depth);
    memcpy(_MinValueStorage, Trend._MinValueStorage, sizeof(double) * _Depth);
    memcpy(_MaxValueStorage, Trend._MaxValueStorage, sizeof(double) * _Depth);

    _Interval = Trend._Interval;
    _Length = Trend._Length;
    _NumberOfPoints = Trend._NumberOfPoints;
    _BaseIndex = Trend._BaseIndex;
    _StartTime = Trend._StartTime;
    _MinTime = Trend._MinTime;
    _MaxTime = Trend._MaxTime;

    return *this;
}

void TKameTrend::SetScale(long TickInterval, long WindowLength)
{
    delete[] _CountsStorage;
    delete[] _SumStorage;
    delete[] _SumOfSqrStorage;
    delete[] _MinValueStorage;
    delete[] _MaxValueStorage;

    _Interval = TickInterval;
    _Length = WindowLength;

    _Depth = (_Length / _Interval) + 1;

    _CountsStorage = new double[_Depth];
    _SumStorage = new double[_Depth];
    _SumOfSqrStorage = new double[_Depth];
    _MinValueStorage = new double[_Depth];
    _MaxValueStorage = new double[_Depth];

    Clear();
}

void TKameTrend::Clear(void)
{
    _BaseIndex = 0;
    _NumberOfPoints = 0;

    _StartTime = 0;
    _MinTime = _StartTime;
    _MaxTime = _MinTime + _Interval * _NumberOfPoints;
}

void TKameTrend::Start(long StartTime)
{
    _StartTime = StartTime;
    _MinTime = _StartTime;
    _MaxTime = _MinTime + _Interval * _NumberOfPoints;
}

void TKameTrend::UpdateRange(long MaxTimeStamp)
{
    while (MaxTimeStamp >= _MaxTime) {
	int Index;
	if (_NumberOfPoints < _Depth) {
	    _NumberOfPoints++;
	    Index = (_BaseIndex + _NumberOfPoints - 1) % _Depth;
	}
	else {
	    Index = _BaseIndex;
	    _BaseIndex = (_BaseIndex + 1) % _Depth;
	}
	_CountsStorage[Index] = 0;
	_SumStorage[Index] = 0;
	_SumOfSqrStorage[Index] = 0;
	_MinValueStorage[Index] = 0;
	_MaxValueStorage[Index] = 0;
	_MaxTime += _Interval;
    }
    _MinTime = _MaxTime - _Interval * _NumberOfPoints;
}
