/* KameVariant.hh */
/* Created by Enomoto Sanshiro on 29 June 2009. */
/* Last updated by Enomoto Sanshiro on 29 June 2009. */


#include <string>
#include <iostream>
#include <sstream>
#include <cstdlib>
#include <cerrno>
#include "KameDefs.hh"
#include "KameVariant.hh"


using namespace std;
using namespace kame;


long TKameVariant::AsLong(void) const throw(TKameException)
{
    if (_Type == vtLong) {
	return _Primitive._LongValue;
    }
    else if (_Type == vtDouble) {
	return (long) _Primitive._DoubleValue;
    }
    else if (_Type == vtVoid) {
	return 0;
    }
    else if (_Type == vtString) {
	long Value;
	const char* Start = _Primitive._StringValue->c_str();
	char* End;
	errno = 0;
	if (strncmp(Start, "0x", 2) == 0) {
	    Value = strtol(Start, &End, 0);
	}
	else {
	    Value = strtol(Start, &End, 10);
	}
	if (((Value == 0) && (errno != 0)) || (*End != '\0')) {
	    throw TKameException(
		"bad string to convert to int: \"" + 
		*_Primitive._StringValue + "\""
	    );
	}
	return Value;
    }
    
    throw TKameException(
	"bad type to convert to int: \"" + AsString()
    );
}

double TKameVariant::AsDouble(void) const throw(TKameException)
{
    if (_Type == vtLong) {
	return (double) _Primitive._LongValue;
    }
    else if (_Type == vtDouble) {
	return _Primitive._DoubleValue;
    }
    else if (_Type == vtVoid) {
	return 0;
    }
    else if (_Type == vtString) {
	double Value;
	const char* Start = _Primitive._StringValue->c_str();
	char* End;
	errno = 0;
	Value = strtod(Start, &End);
	if (((Value == 0) && (errno != 0)) || (*End != '\0')) {
	    throw TKameException(
		"bad string to convert to double: \"" + 
		*_Primitive._StringValue + "\""
	    );
	}
	return Value;
    }

    throw TKameException(
	"bad type to convert to int: \"" + AsString()
    );
}

std::string TKameVariant::AsString(void) const
{
    if (_Type == vtString) {
	return *_Primitive._StringValue;
    }

    std::ostringstream os;
    if (_Type == vtDouble) {
	os << _Primitive._DoubleValue;
    }
    else if (_Type == vtLong) {
	os << _Primitive._LongValue;
    }
    else if (_Type == vtVoid) {
	;
    }
    else {
	os << "Unknown@" << this;
    }

    return os.str();
}

const TKameUnknown& TKameVariant::AsUnknown(void) const throw(TKameException)
{
    if (_Type != vtUnknown) {
	throw TKameException(
	    "bad type to convert to 'unknown': " + AsString()
	);
    }
    
    return *_Primitive._UnknownValue;
}

