/* kame-config.cc.in */
/* Created by Enomoto Sanshiro on 29 June 2009. */
/* Last updated by Enomoto Sanshiro on 29 June 2009. */


#include <iostream>
#include <string>

using namespace std;


static const char* KAME_ROOT = "/home/sanshiro/work/kinoko/src/kernel/lib-common/kame";
static const char* CXX = "g++";
static const char* CPPFLAGS = "";
static const char* CXXFLAGS = " -Wall";
static const char* DEFS = "-DHAVE_CONFIG_H";
static const char* LIBS = "-lm ";
static const char* MATHFLAGS = " -pthread -m32 -I/home/sanshiro/local/root/include";
static const char* MATHLIBS = " -L/home/sanshiro/local/root/lib -lCore -lCint -lRIO -lNet -lHist -lGraf -lGraf3d -lGpad -lTree -lRint -lPostscript -lMatrix -lPhysics -lMathCore -lThread -pthread -lm -ldl -rdynamic -lMinuit";


int main(int argc, char** argv)
{
    if (argc < 2) {
	cout << "Usage: kame-config [OPTIONS]" << endl;
	cout << "Options:" << endl;
	cout << "\t[--cxx]" << endl;
	cout << "\t[--cxxflags]" << endl;
	cout << "\t[--libs]" << endl;
    }

    for (int i = 1; i < argc; i++) {
	string Argument = argv[i];
	
	if (Argument == "--cxx") {
	    cout << CXX << " " << CXXFLAGS << " ";
	}
	else if (
	    (Argument == "--flags") ||
	    (Argument == "--cflags") ||
	    (Argument == "--cxxflags")
	){
	    cout << CPPFLAGS << " " << DEFS << " " << MATHFLAGS << " ";
	    cout << "-I" << KAME_ROOT << " ";
	}
	else if (Argument == "--libs") {
	    cout << "-L" << KAME_ROOT << " -lkame ";
	    cout << MATHLIBS << " " << LIBS;
	}
    }
    cout << endl;

    return 0;
}
