/* contour-test.cc */
/* Created by Enomoto Sanshiro on 14 July 2003. */
/* Last updated by Enomoto Sanshiro on 9 July 2009. */


#include <iostream>
#include <cstdlib>
#include <cmath>
#include "KameHistogram2d.hh"
#include "KameGraph.hh"
#include "KamePlainTextRepository.hh"
#include "KameRootRepository.hh"

using namespace std;
using namespace kame;


int main(int argc, char** argv)
{
    TKameHistogram2d Histogram;

    if (argc > 1) {
	try {
	    TKamePlainTextRepository Repository(argv[1]);
	    //TKameRootRepository Repository(argv[1]);
	    Repository.LoadHistogram2d(Histogram, "test");
	}
	catch (TKameException &e) {
	    cerr << "ERROR: " << e << endl;
	    return -1;
	}
    }
    else {
	static const int NumberOfPoints = 50;
	//static const int NumberOfPoints = 200;
	
	Histogram.SetScale(
	    TKameHistogramScale(NumberOfPoints, -10, 10), 
	    TKameHistogramScale(NumberOfPoints, -10, 10)
	);
	
	Histogram.SetTitle("sin(x) * cos(y)");

	double Step = 20.0 / NumberOfPoints;
	for (double x = -10 + Step/2; x < 10; x += Step) {
	    for (double y = -10 + Step/2; y < 10; y += Step) {
		Histogram.Fill(x, y, cos(x)*cos(y));
		//Histogram.Fill(x, y, (sqrt(x*x + y*y)/10));
	    }
	}
    }

    TKamePlainTextRepository Repository("test-contour");
    //TKameRootRepository Repository("test-contour.root");

    TKameGraph* Graph;
    Graph = Histogram.MakeContour(0);
    Repository.SaveGraph(*Graph, "contour-test-0");
    delete Graph;

    Graph = Histogram.MakeContour(0.5);
    Repository.SaveGraph(*Graph, "contour-test-0.5");
    delete Graph;

    Repository.SaveHistogram2d(Histogram, "test");

    return 0;
}
