/* histogram-test.cc */
/* Created by Enomoto Sanshiro on 11 August 2002. */
/* Last updated by Enomoto Sanshiro on 8 July 2009. */


#include <iostream>
#include <cstdlib>
#include <cmath>
#include <time.h>
#include "KameHistogram.hh"
#include "KamePlainTextRepository.hh"
#include "KameRootRepository.hh"


using namespace std;
using namespace kame;


int main(int argc, char** argv)
{
    TKameHistogram Histogram;

    if (argc > 1) {
	// load a histogram from a repository //
	try {
	    TKamePlainTextRepository Repository(argv[1]);
	    //TKameRootRepository Repository(argv[1]);
	    Repository.LoadHistogram(Histogram, "test");
	}
	catch (TKameException &e) {
	    cerr << "ERROR: " << e << endl;
	    return -1;
	}
    }
    else {
	// create and fill a histogram //
	Histogram.SetTitle("this is a test");
	Histogram.SetScale(TKameHistogramScale(30, -3, 3));
	srand48(time(NULL));
	double Gauss;
	for (int i = 0; i < 1024; i++) {
	    Gauss = sqrt(-2.0 * log(drand48())) * cos(2 * M_PI * drand48());
	    Histogram.Fill(Gauss);
	}
    }

    // show the properties //
    for (unsigned i = 0; i < Histogram.PropertyNameList().size(); i++) {
	string Name = Histogram.PropertyNameList()[i];
	string Value = Histogram.Property(Name);
	cout << "# " << Name << ": " << Value << endl;
    }
    cout << endl;

    // show the histogram //
    unsigned NumberOfBins = Histogram.Scale().NumberOfBins();
    for (unsigned i = 0; i < NumberOfBins; i++) {
	cout << Histogram.Scale().BinValueOf(i) << " ";
	cout << Histogram.CountsOf(i) << endl;
    }

    Histogram.SetAccumulationTime(34603);

    // save the histogram into a repository //
    try {
	TKamePlainTextRepository Repository("test-histogram");
	//TKameRootRepository Repository("test-histogram.root");

	Repository.SaveHistogram(Histogram, "test");
    }
    catch (TKameException &e) {
	cerr << "ERROR: " << e << endl;
	return -1;
    }

    return 0;
}
