/* root2knt.cc */
/* Created by Enomoto Sanshiro on 23 November 2009. */
/* Last updated by Enomoto Sanshiro on 23 November 2009. */


#include <string>
#include <iostream>
#include "KameNtuple.hh"
#include "KamePlainTextRepository.hh"
#include "KameRepositoryFactory.hh"

using namespace std;
using namespace kame;


int main(int argc, char** argv)
{
    if (argc < 3) {
	cerr << "Usage: " << argv[0] << " InputFile.root ObjectName" << endl;
	return -1;
    }
    string FileName = argv[1];
    string ObjectName = argv[2];

    TKameNtuple Ntuple;
    try {
	TKameRepositoryFactory* Factory = (
	    TKameRepositoryFactory::GetInstance("ROOT")
	);
	if (Factory == 0) {
	    throw TKameException("ROOT is not available");
	}
	TKameRepository* InputRepository = Factory->CreateRepository(FileName);
	InputRepository->LoadNtuple(Ntuple, ObjectName);
	delete InputRepository;
    }
    catch (TKameException &e) {
	cerr << "ERROR: " << e << endl;
	return -1;
    }

    for (unsigned i = 0; i < Ntuple.NumberOfColumns(); i++) {
	cout << Ntuple.ColumnNameOf(i) << "/";
	cout << Ntuple.ColumnTypeOf(i) << " ";
    }
    cout << endl;

    try {
	TKamePlainTextRepository Repository("");
	Repository.EnableCompression();
	//Repository.SetHeaderDelimiter(",");
	Repository.SetHeaderQuote("\"");
	//Repository.SetDelimiter(",");
	Repository.SetQuote("\"");

	Repository.SaveNtuple(Ntuple, ObjectName + ".knt");
    }
    catch (TKameException &e) {
	cerr << "ERROR: " << e << endl;
	return -1;
    }

    return 0;
}
