/* trend-test.cc */
/* Created by Enomoto Sanshiro on 13 February 2008. */
/* Last updated by Enomoto Sanshiro on 9 July 2009. */


#include <iostream>
#include <cstdlib>
#include <cmath>
#include <time.h>
#include "KameTrend.hh"
#include "KamePlainTextRepository.hh"
#include "KameRootRepository.hh"

using namespace std;
using namespace kame;


int main(int argc, char** argv)
{
    TKameTrend Trend;

    if (argc > 1) {
	// load a trend from a repository //
	try {
	    TKamePlainTextRepository Repository(argv[1]);
	    //TKameRootRepository Repository(argv[1]);
	    Repository.LoadTrend(Trend, "test");
	}
	catch (TKameException &e) {
	    cerr << "ERROR: " << e << endl;
	    return -1;
	}
    }
    else {
	// create and fill a trend //
	int TickInterval = 10;
	int WindowLength = 120;
	Trend.SetScale(TickInterval, WindowLength);

	long TimeStamp = time(NULL);
	Trend.Start(TimeStamp);

	srand48(time(NULL));
	double Value;
	for (int i = 0; i < 1200; i++) {
	    Value = sqrt(-2.0 * log(drand48())) * cos(2 * M_PI * drand48());
	    Value += 5 + i/600.0;
	    Trend.Fill(TimeStamp, Value);

	    if (((i+1) % 10) == 0) {
		TimeStamp++;
	    }
	}
	
	Trend.UpdateRange(TimeStamp + 25);
    }

    // show the trend //
    unsigned NumberOfPoints = Trend.NumberOfPoints();
    for (unsigned i = 0; i < NumberOfPoints; i++) {
	cout << Trend.PassedTimeOf(i) << " ";
	cout << Trend.CountsOf(i) << " ";
	cout << Trend.SumOf(i) << " ";
	cout << Trend.MeanOf(i) << " ";
	cout << Trend.DeviationOf(i) << " ";
	cout << endl;
    }

    // save the trend into a repository //
    try {
	TKamePlainTextRepository Repository("test-trend");
	//TKameRootRepository Repository("test-trend.root");

	Repository.SaveTrend(Trend, "test");
    }
    catch (TKameException &e) {
	cerr << "ERROR: " << e << endl;
	return -1;
    }

    return 0;
}
