/* Kasp2dHistogram.hh */
/* Created by Enomoto Sanshiro on 13 January 2001. */


#ifndef __Kasp2dHistogram_hh__
#define __Kasp2dHistogram_hh__


#include <string>
#include "KaspObject.hh"
#include "KaspHistogram.hh"
#include "KaspGraph.hh"


class TKasp2dHistogram: public TKaspObject {
  public:
    TKasp2dHistogram(const std::string& Title, const TKaspHistogramScale& XScale, const TKaspHistogramScale& YScale);
    virtual ~TKasp2dHistogram();
    void Clear(void);
    bool HasData(void);
  public:
    inline void Fill(double DataX, double DataY, double Weight = 1.0);
    inline TKaspHistogramScale& XScale(void);
    inline TKaspHistogramScale& YScale(void);
    inline const TKaspHistogramScale& XScale(void) const;
    inline const TKaspHistogramScale& YScale(void) const;
    inline long NumberOfEntries(void) const;
    inline double PeakCounts(void) const;
    inline double CountsOf(int BinNumberX, int BinNumberY) const;
  public:
    TKaspGraph* MakeContour(double Threshold, std::string Title = "");
  protected:
    TKaspHistogramScale _XScale, _YScale;
    double* _Storage;
    double _PeakCounts;
    long _NumberOfEntries;
    int _NumberOfXBins, _NumberOfYBins;
};



inline void TKasp2dHistogram::Fill(double DataX, double DataY, double Weight)
{
    if ((DataX < _XScale.Min()) || (DataX >= _XScale.Max())) {
	;
    }
    else if ((DataY < _YScale.Min()) || (DataY >= _YScale.Max())) {
	;
    }
    else {
	int Index = (
	    _YScale.BinNumberOf(DataY) * _NumberOfXBins + 
	    _XScale.BinNumberOf(DataX)
	);

	double Counts = (_Storage[Index] += Weight);
	if (Counts > _PeakCounts) {
	     _PeakCounts = Counts;
	}

	_NumberOfEntries++;
    }
}

inline TKaspHistogramScale& TKasp2dHistogram::XScale(void)
{
    return _XScale;
}

inline TKaspHistogramScale& TKasp2dHistogram::YScale(void)
{
    return _YScale;
}

inline const TKaspHistogramScale& TKasp2dHistogram::XScale(void) const
{
    return _XScale;
}

inline const TKaspHistogramScale& TKasp2dHistogram::YScale(void) const
{
    return _YScale;
}

inline double TKasp2dHistogram::CountsOf(int BinNumberX, int BinNumberY) const
{
    return _Storage[BinNumberY * _NumberOfXBins + BinNumberX];
}

inline long TKasp2dHistogram::NumberOfEntries(void) const
{
    return _NumberOfEntries;
}

inline double TKasp2dHistogram::PeakCounts(void) const
{
    return _PeakCounts;
}

#endif
