/* KaspObject.cc */
/* Created by Enomoto Sanshiro on 11 November 2002. */
/* Last updated by Enomoto Sanshiro on 11 November 2002. */


#include <iostream>
#include <sstream>
#include <string>
#include <vector>
#include <map>
#include "KaspObject.hh"

using namespace std;


TKaspPropertyList::TKaspPropertyList(void)
{
}

TKaspPropertyList::~TKaspPropertyList()
{
}

int TKaspPropertyList::AddProperty(const std::string& Name, const std::string& Value)
{
    std::map<std::string, int>::iterator i = _PropertyIdTable.find(Name);
    if (i != _PropertyIdTable.end()) {
	SetPropertyValue(i->second, Value);
	return i->second;
    }

    int PropertyId = _PropertyValueList.size();
    _PropertyValueList.push_back(Value);
    _PropertyNameList.push_back(Name);
    _PropertyIdTable[Name] = PropertyId;

    return PropertyId;
}

int TKaspPropertyList::AddProperty(const std::string& Name, long Value)
{
    ostringstream os;
    os << Value;
    
    return AddProperty(Name, os.str());
}

int TKaspPropertyList::AddProperty(const std::string& Name, double Value)
{
    ostringstream os;
    os << Value;
    
    return AddProperty(Name, os.str());
}

void TKaspPropertyList::SetPropertyValue(int PropertyId, const std::string& Value)
{
    _PropertyValueList[PropertyId] = Value;
}

void TKaspPropertyList::SetPropertyValue(int PropertyId, long Value)
{
    ostringstream os;
    os << Value;
    
    SetPropertyValue(PropertyId, os.str());
}

void TKaspPropertyList::SetPropertyValue(int PropertyId, double Value)
{
    ostringstream os;
    os << Value;
    
    SetPropertyValue(PropertyId, os.str());
}

unsigned TKaspPropertyList::NumberOfProperties(void)
{
    return _PropertyValueList.size();
}

string TKaspPropertyList::PropertyNameOf(unsigned Index)
{
    return _PropertyNameList[Index];
}

string TKaspPropertyList::PropertyValueOf(unsigned Index)
{
    return _PropertyValueList[Index];
}

string TKaspPropertyList::PropertyValueOf(const std::string& Name)
{
    std::map<std::string, int>::iterator i = _PropertyIdTable.find(Name);
    if (i != _PropertyIdTable.end()) {
	return _PropertyValueList[i->second];
    }
    else {
	return "";
    }
}



TKaspObject::TKaspObject(const std::string& Title)
{
    _Title = Title;
}

TKaspObject::~TKaspObject()
{
}

const std::string& TKaspObject::Title(void) const
{
    return _Title;
}

void TKaspObject::SetTitle(const std::string& Title)
{
    _Title = Title;
}
