/* KaspObject.hh */
/* Created by Enomoto Sanshiro on 11 November 2002. */
/* Last updated by Enomoto Sanshiro on 11 November 2002. */


#ifndef __KaspObject_hh__
#define __KaspObject_hh__


#include <string>
#include <vector>
#include <map>
#include "KaspDefs.hh"


class TKaspPropertyList {
  public:
    TKaspPropertyList(void);
    virtual ~TKaspPropertyList();
    virtual int AddProperty(const std::string& Name, const std::string& Value);
    virtual int AddProperty(const std::string& Name, long Value);
    virtual int AddProperty(const std::string& Name, double Value);
    virtual void SetPropertyValue(int PropertyId, const std::string& Value);
    virtual void SetPropertyValue(int PropertyId, long Value);
    virtual void SetPropertyValue(int PropertyId, double Value);
    virtual unsigned NumberOfProperties(void);
    virtual std::string PropertyNameOf(unsigned Index);
    virtual std::string PropertyValueOf(unsigned Index);
    virtual std::string PropertyValueOf(const std::string& Name);
  protected:
    std::vector<std::string> _PropertyValueList;
    std::vector<std::string> _PropertyNameList;
    std::map<std::string, int> _PropertyIdTable;
};



class TKaspObject: public TKaspPropertyList {
  public:
    TKaspObject(const std::string& Title);
    virtual ~TKaspObject();
    virtual const std::string& Title(void) const;
    virtual void SetTitle(const std::string& Title);
  protected:
    std::string _Title;
};


#endif
