/* KaspTabular.cc */
/* Created by Enomoto Sanshiro on 25 January 2001. */
/* Last updated by Enomoto Sanshiro on 29 June 2002. */


#include <string>
#include "KaspTabular.hh"


using namespace std;


TKaspTabular::TKaspTabular(const string& Title, int Capacity)
: TKaspObject(Title)
{
    _Capacity = Capacity;
    _FieldNameList = new string[_Capacity];
    _Tabular = new string[_Capacity];

    Clear();
}

TKaspTabular::~TKaspTabular()
{
    delete[] _Tabular;
    delete[] _FieldNameList;
}

void TKaspTabular::Clear(void)
{
    _NumberOfFields = 0;
}

bool TKaspTabular::HasData(void)
{
    return (_NumberOfFields > 0);
}
