/* KaspTabular.hh */
/* Created by Enomoto Sanshiro on 25 January 2001. */
/* Last updated by Enomoto Sanshiro on 29 June 2002. */


#ifndef __KaspTabular_hh__
#define __KaspTabular_hh__


#include <string>
#include "KaspObject.hh"


class TKaspTabular: public TKaspObject {
  public:
    TKaspTabular(const std::string& Title, int Capacity = 256);
    ~TKaspTabular();
    void Clear(void);
    bool HasData(void);
  public:
    inline void Fill(const std::string& Name, const std::string& Value);
    inline int NumberOfFields(void);
    inline const std::string& FieldNameOf(int Index);
    inline const std::string& ValueOf(int Index);
  protected:
    int _Capacity;
    int _NumberOfFields;
    std::string* _FieldNameList;
    std::string* _Tabular;
};



inline void TKaspTabular::Fill(const std::string& Name, const std::string& Value)
{
    if (_NumberOfFields + 1 >= _Capacity) {
	return;
    }

    _FieldNameList[_NumberOfFields] = Name;
    _Tabular[_NumberOfFields] = Value;
    
    _NumberOfFields++;
}

inline int TKaspTabular::NumberOfFields(void)
{
    return _NumberOfFields;
}

inline const std::string& TKaspTabular::FieldNameOf(int Index)
{
    return _FieldNameList[Index];
}

inline const std::string& TKaspTabular::ValueOf(int Index)
{
    return _Tabular[Index];
}

#endif
