/* contour-test.cc */
/* Created by Enomoto Sanshiro on 14 July 2003. */
/* Last updated by Enomoto Sanshiro on 14 July 2003. */


#include <iostream>
#include <cstdlib>
#include <cmath>
#include "Kasp2dHistogram.hh"
#include "KaspGraph.hh"
#include "KaspPlainTextRepository.hh"

using namespace std;


int main(int argc, char** argv)
{
    static const int NumberOfPoints = 20;
    //static const int NumberOfPoints = 50;
    //static const int NumberOfPoints = 200;

    TKasp2dHistogram Histogram("contour test", 
        TKaspHistogramScale(NumberOfPoints, -10, 10), 
        TKaspHistogramScale(NumberOfPoints, -10, 10)
    );

    double Step = 20.0 / NumberOfPoints;
    for (double x = -10 + Step/2; x < 10; x += Step) {
	for (double y = -10 + Step/2; y < 10; y += Step) {
	    Histogram.Fill(x, y, cos(x)*cos(y));
	    //Histogram.Fill(x, y, (sqrt(x*x + y*y)/10));
	}
    }

    TKaspGraph* Graph;
    TKaspPlainTextRepository Repository;

    Graph = Histogram.MakeContour(0);
    Repository.SaveGraph("contour-test-0.knt", Graph);
    delete Graph;

    Graph = Histogram.MakeContour(0.5);
    Repository.SaveGraph("contour-test-0.5.knt", Graph);
    delete Graph;

    return 0;
}
