/* root2knt.cc */
/* Created by Enomoto Sanshiro on 2 April 2004. */
/* Last updated by Enomoto Sanshiro on 2 April 2004. */


#include <iostream>
#include <cstdlib>
#include <cmath>
#include <time.h>
#include "Kasp2dHistogram.hh"
#include "KaspPlainTextRepository.hh"
#include "KaspRootRepository.hh"

using namespace std;


int main(int argc, char** argv)
{
    TKasp2dHistogram* Histogram = 0;

    // loading a histogram from a repository //
    try {
	TKaspRootRepository Repository("EnergyScaleChi2.root");
	Histogram = Repository.Load2dHistogram("chis");
    }
    catch (TKaspException &e) {
	cerr << "ERROR: " << e << endl;
	return -1;
    }

    // saving a histogram into a repository //
    try {
	TKaspPlainTextRepository Repository("");
	Repository.Save2dHistogram("EnergyScaleChi2.knt", Histogram);
    }
    catch (TKaspException &e) {
	cerr << "ERROR: " << e << endl;
	delete Histogram;
	return -1;
    }

    delete Histogram;

    return 0;
}
