/* KcomComponent.hh */
/* Created by Enomoto Sanshiro on 25 March 2000. */
/* Updated by Enomoto Sanshiro on 19 May 2003. */
/* Last updated by Enomoto Sanshiro on 19 January 2010. */


#ifndef __KcomComponent_hh__
#define __KcomComponent_hh__


#include <iostream>
#include <string>
#include "KorbOrb.hh"
#include "KorbObjectReference.hh"
#include "KcomDefs.hh"
#include "KcomExchangeCenter.hh"
#include "KcomComponentDescriptor.hh"
#include "KcomRegistry.hh"
#include "KcomRegistryOrb.hh"
#include "KcomTerminal.hh"


class TKcomComponent {
  public:
    // these methods are called by TKcomProcess (and others) //
    TKcomComponent(const std::string& TypeName);
    virtual ~TKcomComponent();
    virtual std::string TypeName(void) const;
    virtual std::string ComponentName(void) const;
    virtual void AttachSystem(const std::string& ComponentName, TKorbOrb* Orb);
    virtual void AttachIO(std::istream* InputStream, std::ostream* OutputStream, TKcomTerminal* Terminal = 0);
    virtual void DetachSystem(void);
    virtual void DetachIO(void);
    virtual TKcomComponentDescriptor* Descriptor(void);
    virtual int DispatchEvent(TKcomEvent& Event, TKcomEventResponse& EventResponce);
    virtual bool IsStopRequested(void);
  public:
    // override these methods in derived component class //
    virtual void Initialize(void) throw(TKcomException) {}
    virtual void Finalize(void) throw(TKcomException) {}
    virtual void BuildDescriptor(TKcomComponentDescriptor& Descriptor) {}
    virtual int ProcessEvent(int EventId, TKcomEvent& Event, TKcomEventResponse& EventResponse);
    virtual int ProcessEvent(int EventId, TKcomEvent& Event);
    virtual int DoTransaction(void) throw(TKcomException);
    virtual void OnTransaction(void) throw(TKcomException);
  protected:
    // use these methods in derived component class //
    virtual int EmitEvent(int EventId, TKcomEvent& Event) throw(TKcomException);
    virtual int EmitEventOneWay(int EventId, TKcomEvent& Event) throw(TKcomException);
    virtual int EmitEventTo(const std::string& TargetName, TKcomEvent& Event, TKcomEventResponse& Response) throw(TKcomException);
    virtual bool SetProperty(int PropertyId, const std::string& Value);
    virtual bool SetLongProperty(int PropertyId, long LongValue);
    virtual bool GetPropertyOf(const std::string& ComponentName, const std::string& PropertyName, std::string& Value);
    virtual bool GetLongPropertyOf(const std::string& ComponentName, const std::string& PropertyName, long& LongValue);
    virtual TKcomRegistry* Registry(void);
    virtual std::istream& InputStream(void);
    virtual std::ostream& OutputStream(void);    
    virtual TKcomTerminal* Terminal(void);    
    virtual void Terminate(void);
  public:
    // for limited use //
    static std::string PropertyRegistryPathOf(const std::string& ComponentName, const std::string& PropertyName);
  private:
    void ExportObjects(TKcomComponentDescriptor* Descriptor, TKorbObjectAdapter* ObjectAdapter) throw(TKcomException);
    void ImportObjects(TKcomComponentDescriptor* Descriptor, TKcomExchangeCenter* ExchangeCenter, TKorbOrb* Orb) throw(TKcomException);
  private:
    TKorbOrb* _Orb;
    TKcomExchangeCenterProxy* _ExchangeCenter;
    TKcomRegistryProxy* _Registry;
    TKcomComponentDescriptor* _Descriptor;
    std::string _TypeName;
    std::string _ComponentName;
    std::istream* _InputStream;
    std::ostream* _OutputStream;
    TKcomTerminal* _Terminal;
    bool _IsStopRequested;
};


#endif

