/* KcomComponentDescriptor.hh */
/* Created by Enomoto Sanshiro on 30 March 2000. */
/* Last updated by Enomoto Sanshiro on 20 August 2000. */


#ifndef __KcomComponentDescriptor_hh__
#define __KcomComponentDescriptor_hh__


#include <string>
#include <vector>
#include <map>
#include "KorbObjectProxy.hh"
#include "KorbObjectMessenger.hh"
#include "KcomInterfaceDeclaration.hh"


class TKcomComponentDescriptor: public TKcomComponentDeclaration {
  public:
    TKcomComponentDescriptor(const std::string& TypeName);
    virtual ~TKcomComponentDescriptor();
    virtual void RegisterProperty(int PropertyId, const TKcomPropertyDeclaration& Property);
    virtual void RegisterExportObject(TKorbObjectMessenger* Messenger, const TKcomObjectDeclaration& Object);
    virtual void RegisterImportObject(TKorbObjectProxy* Proxy, const TKcomObjectDeclaration& Object);
    virtual void RegisterEventSource(int EventId, const TKcomEventDeclaration& Event);
    virtual void RegisterEventSlot(int EventId, const TKcomEventDeclaration& Event);
  public:
    virtual std::string PropertyNameOf(int PropertyId);
    virtual const std::vector<std::pair<TKorbObjectMessenger*, TKcomObjectDeclaration> >& ExportObjectList(void); 
    virtual const std::vector<std::pair<TKorbObjectProxy*, TKcomObjectDeclaration> >& ImportObjectList(void); 
    virtual std::string EventNameOf(int EventId);
    virtual int EventIdOf(const std::string& EventName);
  private:
    std::map<int, std::string> _PropertyIdToNameTable;
    std::vector<std::pair<TKorbObjectMessenger*, TKcomObjectDeclaration> > _ExportObjectList;
    std::vector<std::pair<TKorbObjectProxy*, TKcomObjectDeclaration> > _ImportObjectList;
    std::map<int, std::string> _EventIdToNameTable;
    std::map<std::string, int> _EventNameToIdTable;
};


#endif

