/* KcomComponentOrb.hh */
/* Created by Enomoto Sanshiro on 25 March 2000. */
/* Last updated by Enomoto Sanshiro on 6 April 2002. */


#ifndef __KcomComponentOrb_hh__
#define __KcomComponentOrb_hh__


#include "KorbOrb.hh"
#include "KorbObjectAdapter.hh"
#include "KorbObjectMessenger.hh"
#include "KcomDefs.hh"
#include "KcomComponent.hh"


// Note that this class does NOT inherit TKcomComponent.
class TKcomComponentProxy {
  public:
    TKcomComponentProxy(const TKorbObjectReference& ObjRef, TKorbOrb* Orb);
    virtual ~TKcomComponentProxy();
    virtual int EmitEvent(TKcomEvent& Event, bool IsOneWay) throw(TKcomException);
    virtual int WaitEventResponse(int RequestId, TKcomEventResponse& EventResponse, int TimeOut_sec = 0) throw(TKcomException);
  public:
    virtual const TKorbObjectReference& ObjectReference(void) const;
  protected:
    TKorbObjectReference _ObjRef;
    TKorbOrbPacket* _OrbPacket;
    TKorbOrb* _Orb;
};



class TKcomComponentMessenger: public TKorbObjectMessenger {
  public:
    enum TMethodId {
	MethodId_DispatchEvent
    };
  public:
    TKcomComponentMessenger(TKcomComponent* Component);
    virtual ~TKcomComponentMessenger();
    virtual int DispatchMethodInvocation(TKorbOrbPacket& OrbPacket) throw(TKorbException);
  protected:
    TKcomComponent* _Component;
};


#endif
