/* KcomEvent.hh */
/* Created by Enomoto Sanshiro on 30 March 2000. */
/* Last updated by Enomoto Sanshiro on 6 April 2002. */


#ifndef __KcomEvent_hh__
#define __KcomEvent_hh__

#include <string>
#include <vector>
#include "KorbStreamable.hh"


class TKcomEvent: public TKorbStreamable {
  public:
    TKcomEvent(void);
    TKcomEvent(const std::string& Name);
    virtual  ~TKcomEvent();
    virtual std::string& Name(void);
    virtual std::string& SourceName(void);
    virtual std::vector<std::string>& ArgumentList(void);
    virtual void Dump(std::ostream& os);
  public:
    virtual int WriteTo(void* Buffer, int BufferSize) const;
    virtual int ReadFrom(void* Buffer, int BufferSize);
  protected:
    std::string _Name;
    std::string _SourceName;
    std::vector<std::string> _ArgumentList;
};


class TKcomEventResponse: public TKorbStreamable {
  public:
    TKcomEventResponse(void);
    virtual ~TKcomEventResponse();
    virtual int& IsError(void);
    virtual std::string& ReturnValue(void);
  public:
    virtual int WriteTo(void* Buffer, int BufferSize) const;
    virtual int ReadFrom(void* Buffer, int BufferSize);
  protected:
    int _IsError;
    std::string _ReturnValue;
};


#endif

