/* KcomRegistryOrb.hh */
/* Created by Enomoto Sanshiro on 28 May 2000. */
/* Last updated by Enomoto Sanshiro on 19 May 2003. */


#ifndef __KcomRegistryOrb_hh__
#define __KcomRegistryOrb_hh__


#include <string>
#include <vector>
#include "KorbOrb.hh"
#include "KorbObjectProxy.hh"
#include "KorbObjectMessenger.hh"
#include "KcomDefs.hh"
#include "KcomRegistry.hh"


class TKcomRegistryProxy: public TKorbObjectProxy, public TKcomRegistry {
  public:
    TKcomRegistryProxy(TKorbOrb* Orb);
    virtual ~TKcomRegistryProxy();
    virtual void SetValue(const std::string& RegistryPath, const std::string& Value);
    virtual bool GetValue(const std::string& RegistryPath, std::string& Value);
    virtual std::vector<std::string> ChildEntryNameListOf(const std::string& RegistryPath);
    virtual int GetSequenceValue(const std::string& SequenceName);
    virtual void SaveTo(const std::string& FileName, const std::string& BasePath = "") throw(TKcomException);
  public:
    TKcomRegistryEntry* GetEntry(std::string RegistryPath, TKcomRegistryEntry* BaseEntry = 0);
};


class TKcomRegistryMessenger: public TKorbObjectMessenger {
  public:
    enum TMethodId {
	MethodId_SetValue,
	MethodId_GetValue,
	MethodId_ChildEntryNameListOf,
	MethodId_GetSequenceValue,
	MethodId_SaveTo,
	NumberOfMethods
    };
  public:
    TKcomRegistryMessenger(TKcomRegistry* Registry);
    virtual ~TKcomRegistryMessenger();
    virtual int DispatchMethodInvocation(TKorbOrbPacket& OrbPacket) throw(TKorbException);
  protected:
    virtual int SetValue(TKorbOrbPacket& OrbPacket);
    virtual int GetValue(TKorbOrbPacket& OrbPacket);
    virtual int ChildEntryNameListOf(TKorbOrbPacket& OrbPacket);
    virtual int GetSequenceValue(TKorbOrbPacket& OrbPacket);
    virtual int SaveTo(TKorbOrbPacket& OrbPacket);
  protected:
    TKcomRegistry* _Registry;
};


class TKcomRegistryServer {
  public:
    TKcomRegistryServer(void);
    virtual ~TKcomRegistryServer();
    virtual void Start(void) throw(TKcomException);
    virtual TKcomRegistry* Registry(void);
  protected:
    TKorbOrb* _Orb;
    TKorbObjectAdapter* _ObjectAdapter;
    TKorbObjectMessenger* _RegistryMessenger;
    TKcomRegistry* _Registry;
    std::string _RepositoryFileName;
};

#endif

