/* MessageBoard.hh */
/* Created by Enomoto Sanshiro on 21 August 2000. */
/* Last updated by Enomoto Sanshiro on 21 August 2000. */


#ifndef __MessageBoard_hh__
#define __MessageBoard_hh__


#include <iostream>
#include <string>
#include "KorbOrb.hh"
#include "KorbObjectAdapter.hh"
#include "KorbObjectProxy.hh"
#include "KorbObjectMessenger.hh"


class TMessageBoard {
  public:
    TMessageBoard(std::ostream* OutputStream);
    virtual ~TMessageBoard();
    virtual int Write(std::string Name, std::string Contents);
  protected:
    std::ostream* _OutputStream;
};


class TMessageBoardProxy: public TKorbObjectProxy, public TMessageBoard {
  public:
    TMessageBoardProxy(TKorbOrb* Orb = 0);
    virtual ~TMessageBoardProxy();
    virtual int Write(std::string Name, std::string Contents);
};



class TMessageBoardMessenger: public TKorbObjectMessenger {
  public:
    enum TMethodId {
	MethodId_Write
    };
  public:
    TMessageBoardMessenger(TMessageBoard* MessageBoard);
    virtual ~TMessageBoardMessenger();
    virtual int DispatchMethodInvocation(TKorbOrbPacket& OrbPacket) throw(TKorbException);
  protected:
    TMessageBoard* _MessageBoard;
};


#endif

