/* kcom-registry-test.cc */
/* Created by Enomoto Sanshiro on 28 March 2000. */
/* Last updated by Enomoto Sanshiro on 28 March 2000. */


#include <iostream>
#include <fstream>
#include "KcomRegistry.hh"
#include "KcomRegistryRepository.hh"

using namespace std;


int main(int argc, char** argv)
{
    if (argc < 2) {
	cerr << "usage: " << argv[0] << " RegistryFileName" << endl;
	return 0;
    }

    string RegistryFileName = argv[1];

    TKcomRegistryRepository RegistryRepository(RegistryFileName);
    TKcomRegistry* Registry = 0;
    try {
	Registry = RegistryRepository.Load();
	RegistryRepository.Save(Registry);
    }
    catch (TKcomException &e) {
	cerr << "ERROR: " << e << endl;
	return -1;
    }
    
    cout << "-----" << endl;
    Registry->SetValue("/Japanese/DayTime", "Konnitiha");
    RegistryRepository.Save(Registry);

    cout << "-----" << endl;
    string Name = "/English/DayTime/Evening";
    string Value;
    if (Registry->GetValue(Name, Value)) {
	cout << Name << " = \"" << Value << "\"" << endl;
    }

    delete Registry;

    return 0;
}
