/* KdbcDriver.hh */
/* Created by Enomoto Sanshiro on 3 November 2000. */
/* Last updated by Enomoto Sanshiro on 3 November 2000. */


#ifndef __KdbcDriver_hh__
#define __KdbcDriver_hh__

#include <string>
#include "KdbcDefs.hh"
#include "KdbcResult.hh"


class TKdbcConnection;


class TKdbcDriver {
  public:
    TKdbcDriver(void);
    virtual ~TKdbcDriver();
    virtual TKdbcDriver* Clone(void) = 0;
    virtual TKdbcConnection* CreateConnection(const std::string& DatabaseName) throw(TKdbcException) = 0;
    virtual TKdbcConnection* CreateConnection(const std::string& DatabaseName, const std::string& Host, const std::string& Port, const std::string& UserName, const std::string& Password) throw(TKdbcException) = 0;
};



class TKdbcConnection {
  public:
    TKdbcConnection(void);
    virtual ~TKdbcConnection();
    virtual void Disconnect(void) = 0;
    virtual TKdbcResult* ExecuteSql(const std::string& Statement) throw(TKdbcException) = 0;
};


#endif
