/* KdbcManager.hh */
/* Created by Enomoto Sanshiro on 3 November 2000. */
/* Last updated by Enomoto Sanshiro on 3 November 2000. */


#ifndef __KdbcManager_hh__
#define __KdbcManager_hh__

#include <iostream>
#include <string>
#include <map>
#include "KdbcDefs.hh"
#include "KdbcDriver.hh"


class TKdbcManager {
  protected:
    TKdbcManager(void);
  public:
    virtual ~TKdbcManager();
    static TKdbcManager* GetInstance(void);
    virtual void RegisterDriver(const std::string& DriverName, TKdbcDriver* Driver);
    virtual TKdbcDriver* CreateDriver(const std::string& DriverName = "") throw(TKdbcException);
    virtual void ShowDriverList(std::ostream& os) const;
  protected:
    static TKdbcManager* _Instance;
    std::map<std::string, TKdbcDriver*> _DriverTable;
};


class TKdbcDriverCreator {
  public:
    TKdbcDriverCreator(const std::string& DriverName, TKdbcDriver* Driver);
};



#endif
