/* KdbcResult.hh */
/* Created by Enomoto Sanshiro on 3 November 2000. */
/* Last updated by Enomoto Sanshiro on 3 November 2000. */


#ifndef __KdbcResult_hh__
#define __KdbcResult_hh__

#include <iostream>
#include <string>
#include "KdbcDefs.hh"


class TKdbcResult {
  public:
    TKdbcResult(void);
    virtual ~TKdbcResult();
    virtual void Destroy(void) = 0;
    virtual bool IsQueryResult(void);
    virtual long NumberOfRows(void) throw(TKdbcException);
    virtual long NumberOfColumns(void) throw(TKdbcException);
    virtual long NumberOfAffectedRows(void) throw(TKdbcException);
    virtual std::string FieldNameOf(long Column) throw(TKdbcException) = 0;
    virtual std::string GetValueOf(long Row, long Column) throw(TKdbcException) = 0;
    virtual std::string GetValueOf(long Row, const std::string& FieldName) throw(TKdbcException) = 0;
  public:
    virtual bool Next(void);
    virtual std::string GetString(long Column) throw(TKdbcException);
    virtual std::string GetString(const std::string& FieldName) throw(TKdbcException);
    virtual long GetLong(long Column) throw(TKdbcException);
    virtual long GetLong(const std::string& FieldName) throw(TKdbcException);
    virtual double GetDouble(long Column) throw(TKdbcException);
    virtual double GetDouble(const std::string& FieldName) throw(TKdbcException);
    virtual void Dump(std::ostream& os);
  protected:
    bool _IsQueryResult;
    long _NumberOfRows, _NumberOfColumns, _NumberOfAffectedRows;
    long _CurrentRow;
};


#endif
