/* dbms-SQLite.hh */
/* Created by Enomoto Sanshiro on 1 October 2002. */
/* Last updated by Enomoto Sanshiro on 1 October 2002. */


#ifndef __dbms_SQLite_hh__
#define __dbms_SQLite_hh__


#include <string>
#include <vector>
#include <map>
#include <sqlite.h>
#include "KdbcManager.hh"
#include "KdbcDriver.hh"
#include "KdbcResult.hh"



class TKdbcDriver_SQLite: public TKdbcDriver {
  public:
    TKdbcDriver_SQLite(void);
    virtual ~TKdbcDriver_SQLite();
    virtual TKdbcDriver* Clone(void);
    virtual TKdbcConnection* CreateConnection(const std::string& DatabaseName) throw(TKdbcException);
    virtual TKdbcConnection* CreateConnection(const std::string& DatabaseName, const std::string& Host, const std::string& Port, const std::string& UserName, const std::string& Password) throw(TKdbcException);
};



class TKdbcConnection_SQLite: public TKdbcConnection {
  public:
    TKdbcConnection_SQLite(sqlite* Sqlite);
    virtual ~TKdbcConnection_SQLite();
    virtual void Disconnect(void);
    virtual TKdbcResult* ExecuteSql(const std::string& Statement) throw(TKdbcException);
  protected:
    sqlite* _Sqlite;
};



class TKdbcResult_SQLite: public TKdbcResult {
  public:
    TKdbcResult_SQLite(void);
    virtual ~TKdbcResult_SQLite();
    virtual void Destroy(void);
    virtual std::string FieldNameOf(long Column) throw(TKdbcException);
    virtual std::string GetValueOf(long Raw, long Column) throw(TKdbcException);
    virtual std::string GetValueOf(long Raw, const std::string& FieldName) throw(TKdbcException);
  public:
    void SetQueryResultFlag(void);
    void SetNumberOfAffectedRows(int NumberOfAffectedRows);
    void SetFieldList(int NumberOfColumns, char** FieldNameList);
    void AddRow(char** RowData);
  protected:
    std::vector<std::string> _FieldNameList;
    std::map<std::string, int> _FieldNameTable;
    std::vector<std::string*> _ValueList;
};


#endif
