/* KiscAnalysisScript.hh */
/* Created by Enomoto Sanshiro on 17 May 2002. */
/* Last updated by Enomoto Sanshiro on 10 July 2009. */


#ifndef __KiscAnalysisScript_hh_
#define __KiscAnalysisScript_hh_

#include <string>
#include <vector>
#include "ParaParser.hh"
#include "KiscNtuple.hh"


class TKiscAnalysisScript: public TParaParser {
  public:
    TKiscAnalysisScript(void);
    virtual ~TKiscAnalysisScript();
    virtual TParaObjectPrototypeTable* CreateObjectPrototypeTable(void);
};


class TKiscAnalysisObject: public TParaObjectPrototype {
  public:
    TKiscAnalysisObject(const std::string& ClassName);
    virtual ~TKiscAnalysisObject();
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    virtual kame::TKameObject& KameObject(void) = 0;
    virtual TKiscKameObject& KiscKameObject(void) = 0;
  protected:
    virtual void Title(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual void SetDelimiter(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual void SetQuote(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual void Load(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual void Save(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual void PropertyList(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual void AddProperty(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual void GetPropertyValueOf(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual void GetSpiltPropertyValueOf(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    enum {
	MethodId_Title = TParaObjectPrototype::_NumberOfMethods,
	MethodId_SetDelimiter,
	MethodId_SetQuote,
	MethodId_Load,
	MethodId_Save,
	MethodId_PropertyList,
	MethodId_AddProperty,
	MethodId_GetPropertyValueOf,
	MethodId_GetSpiltPropertyValueOf,
	_NumberOfMethods
    };
};


class TKiscNtupleObject: public TKiscAnalysisObject {
  public:
    TKiscNtupleObject(void);
    virtual ~TKiscNtupleObject();
    virtual TParaObjectPrototype* Clone(void);
    virtual kame::TKameObject& KameObject(void);
    virtual TKiscKameObject& KiscKameObject(void);
    virtual void Construct(const std::string& ClassName, std::vector<TParaValue*>& ArgumentList) throw(TScriptException);
    virtual int MethodIdOf(const std::string& MethodName);
    virtual int InvokeMethod(int MethodId, std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    virtual TParaValue& EvaluateOperator(TParaOperator* Operator, TParaValue& LeftValue, TParaValue& RightValue, TParaSymbolTable* SymbolTable, TParaValue& Result) throw(TScriptException);
  protected:
    void Fill(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    void Clear(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    void GetColumnOf(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    void GetRowOf(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    void NumberOfColumns(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    void NumberOfRows(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    void ColumnNameOf(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    void ColumnIndexOf(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
    void SetColumnName(std::vector<TParaValue*>& ArgumentList, TParaValue& ReturnValue) throw(TScriptException);
  protected:
    enum {
	MethodId_Fill = TKiscAnalysisObject::_NumberOfMethods,
	MethodId_Clear,
	MethodId_GetColumnOf,
	MethodId_GetRowOf,
	MethodId_NumberOfColumns,
	MethodId_NumberOfRows,
	MethodId_ColumnNameOf,
	MethodId_ColumnIndexOf,
	MethodId_SetColumnName,
	_NumberOfMethods
    };
  protected:
    TKiscNtuple _Ntuple;
};


#endif
