/* KiscFancyConfigFile.hh */
/* Created by Enomoto Sanshiro on 19 July 2001 */
/* Last updated by Enomoto Sanshiro on 20 July 2001. */


#ifndef __KiscFancyConfigFile_hh__
#define __KiscFancyConfigFile_hh__


#include <string>
#include <vector>
#include "ParaTokenizer.hh"
#include "ParaValue.hh"
#include "KiscScript.hh"
#include "KiscConfigFile.hh"


class TKiscFancyConfigFile: public TKiscConfigFile {
  public:
    TKiscFancyConfigFile(const std::string& FileName);
    TKiscFancyConfigFile(const std::string& FileName, int argc, char** argv);
    virtual ~TKiscFancyConfigFile();
    virtual void SetEntryKeyword(const std::string& Keyword);
  protected:
    virtual void Construct(void) throw(TScriptException);
  public:
    virtual const std::string& CurrentSectionName(void);
    virtual void SetCurrentSectionName(const std::string& SectionName);
    virtual void AddEntry(const std::string& EntryName, const std::string& Qualifier, const std::vector<TParaValue>& ValueList);
  protected:
    int _argc;
    char** _argv;
    std::string _EntryKeyword;
    std::string _CurrentSectionName;
};


class TKiscFancyConfigFileParser: public TKiscScript {
  public:
    TKiscFancyConfigFileParser(TKiscFancyConfigFile* ConfigFile);
    TKiscFancyConfigFileParser(TKiscFancyConfigFile* ConfigFile, int argc, char** argv);
    virtual ~TKiscFancyConfigFileParser();
    virtual void SetEntryKeyword(const std::string& Keyword);
  protected:
    virtual TParaTokenTable* CreateTokenTable(void);
    virtual TParaStatementTable* CreateStatementTable(void);
  protected:
    TKiscFancyConfigFile* _ConfigFile;
    std::string _EntryKeyword;
};


class TKiscConfigFileSectionStatement: public TParaStatement {
  public:
    TKiscConfigFileSectionStatement(TKiscFancyConfigFile* ConfigFile, const std::string& EntryKeyword);
    virtual ~TKiscConfigFileSectionStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKiscFancyConfigFile* _ConfigFile;
    std::string _SectionName;
    TParaStatement* _Statement;
    std::string _EntryKeyword;
};


class TKiscConfigFileSetStatement: public TParaStatement {
  public:
    TKiscConfigFileSetStatement(TKiscFancyConfigFile* ConfigFile);
    virtual ~TKiscConfigFileSetStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKiscFancyConfigFile* _ConfigFile;
    std::string _EntryName;
    std::string _Qualifier;
    std::vector<TParaExpression*> _ValueExpressionList;
};


class TKiscConfigFileImportStatement: public TParaStatement {
  public:
    TKiscConfigFileImportStatement(TKiscFancyConfigFile* ConfigFile);
    virtual ~TKiscConfigFileImportStatement();
    virtual TParaStatement* Clone(void);
    virtual std::string FirstToken(void) const;
    virtual void Parse(TParaTokenizer* Tokenizer, TParaStatementParser* StatementParser, TParaSymbolTable* SymbolTable) throw(TScriptException);
    virtual TExecResult Execute(TParaSymbolTable* SymbolTable) throw(TScriptException);
  protected:
    TKiscFancyConfigFile* _ConfigFile;
    std::string _ImportedSectionPath;
};


#endif
