/* KiscInterpreter.hh */
/* Created by Enomoto Sanshiro on 14 December 2001. */
/* Last updated by Enomoto Sanshiro on 28 May 2008. */


#ifndef __KiscInterpreter_hh__
#define __KiscInterpreter_hh__


#include <iostream>
#include <fstream>
#include <vector>
#include <deque>
#include <MushConsoleStream.hh>
#include <MushArgumentList.hh>
#include <MushSignal.hh>
#include "KiscScript.hh"


class TKiscInterpreter: public TMushSignalClient {
  public:
    TKiscInterpreter(int argc, char** argv) throw(TScriptException);
    virtual ~TKiscInterpreter();
    virtual void AddStartupFile(const std::string& FileName);
    virtual void SetHistoryFile(const std::string& FileName);
    virtual void Start(void) throw(TScriptException);
  public:
    virtual void OnCatchSignal(int SignalId);
  protected:
    virtual void Initialize(void) throw(TScriptException);
    virtual void ProcessCommand(void) throw(TScriptException);
    virtual void ProcessScript(void) throw(TScriptException);
    virtual void PrintResult(void) throw(TScriptException);
  protected:
    std::string _HistoryFileName;
    std::deque<std::string> _ScriptFileNameList;
    TMushArgumentList* _ArgumentList;
    TMushConsole* _Console;
    std::istream* _InputStream;
    std::vector<std::ifstream*> _InputStreamList;
    bool _IsResultPrintEnabled, _IsInteractive;
  protected:
    TKiscScript* _Script;
    TParaTokenTable* _TokenTable;
    TParaSymbolTable* _SymbolTable;
    TParaPackage* _Package;
    TParaStatementParser* _StatementParser;
    TParaTokenizer* _Tokenizer;
    std::vector<TParaPackageEntry*> _EntryList;
  private:
    TParaValue* _LastResultVariable;
    TParaValue* _ArgumentListVariable;
    TParaValue* _EnvironmentVariableTableVariable;
    bool _IsStopRequested;
    enum TBase { Base_dec, Base_hex } _PrintBase;
};


#endif
