/* config-file-test.cc */
/* Created by Enomoto Sanshiro on 18 July 2001 */
/* Last updated by Enomoto Sanshiro on 18 July 2001. */


#include <iostream>
#include <sstream>
#include "KiscConfigFile.hh"
#include "KiscFancyConfigFile.hh"

using namespace std;


int main(int argc, char** argv)
{
    if (argc < 2) {
	cerr << "usage:" << endl;
	cerr << "  " << argv[0] << " ConfigFileName" << endl;
	cerr << "  > Section EntryName [Qualifier]" << endl;
	cerr << "  > ^D" << endl;
	return 0;
    }
    string ConfigFileName = argv[1];

    TKiscConfigFile* ConfigFile = 0;
    try {
	//ConfigFile = new TKiscBasicConfigFile(ConfigFileName);
	ConfigFile = new TKiscFancyConfigFile(ConfigFileName);

	cout << endl;
	ConfigFile->DumpTo(cout);
	cout << endl;

	string Line;
	while (cout << "> ", getline(cin, Line, '\n')) {
	    string Section, EntryName, Qualifier;
	    istringstream LineStream(Line);
	    LineStream >> Section >> EntryName >> Qualifier;

	    cout << Section << "/" << EntryName << "[" << Qualifier << "] = ";

	    ConfigFile->SetTargetSection(Section, Qualifier);
	    const vector<TParaValue>& EntryList = ConfigFile->GetValueListOf(EntryName);
	    for (unsigned i = 0; i < EntryList.size(); i++) {
		cout << EntryList[i].AsString() << ", ";
	    }
	    cout << endl;
	}
    }
    catch (TScriptException &e) {
	cerr << endl;
	cerr << "ERROR: " << e << flush;
    }
    delete ConfigFile;

    cout << endl;

    return 0;
}
