/* KmlcFunctionFitter.hh */
/* Created by Enomoto Sanshiro on 18 January 2001 */
/* Last updated by Enomoto Sanshiro on 26 May 2002. */


#ifndef __KmlcFunctionFitter_hh__
#define __KmlcFunctionFitter_hh__


#include "KumaVector.hh"
#include "KumaPrimitive.hh"
#include "KumaFunction.hh"
#include "KmlcFunctionMinimizer.hh"



class TKmlcChiSquaredFunction: public kuma::TKumaFunction {
  public:
    TKmlcChiSquaredFunction(kuma::TKumaParameterizedFunction& Function, kuma::TKumaPrimitiveVector& XDataList, kuma::TKumaPrimitiveVector& YDataList);
    virtual ~TKmlcChiSquaredFunction(void);
    virtual double ValueOf(const double* InputValueList, int InputListSize);
  protected:
    kuma::TKumaParameterizedFunction& _Function;
    kuma::TKumaPrimitiveVector& _XDataList;
    kuma::TKumaPrimitiveVector& _YDataList;
};


class TKmlcFunctionFitter {
  public:
    TKmlcFunctionFitter(TKmlcFunctionMinimizer* Minimizer);
    virtual ~TKmlcFunctionFitter(void);
    virtual double Fit(kuma::TKumaParameterizedFunction& Function, kuma::TKumaPrimitiveVector& XDataList, kuma::TKumaPrimitiveVector& YDataList) throw(TKmlcException);
  protected:
    TKmlcFunctionMinimizer* _Minimizer;
};


#endif
