/* math-Root.cc */
/* Created by Enomoto Sanshiro on 28 September 2002 */
/* Last updated by Enomoto Sanshiro on 28 September 2002. */


#include "KumaPrimitive.hh"
#include "KumaFunction.hh"
#include "KmlcManager.hh"
#include "KmlcFunctionMinimizer.hh"
#include "math-Root.hh"
#include <cfloat>
#include <TMinuit.h>

using namespace std;
using namespace kuma;


static TKmlcFunctionMinimizerCreator Creator1(
    "Root", new TKmlcFunctionMinimizer_Root()
);


#define VERBOSE


TKumaFunction* ObjectFunction = 0;
int NumberOfParameters = 0;

void FCN(Int_t& npar, Double_t* grad, Double_t& fval, Double_t* xval, Int_t flag)
{
    fval = ObjectFunction->ValueOf(xval, NumberOfParameters);
}



TKmlcFunctionMinimizer_Root::TKmlcFunctionMinimizer_Root(void)
{
}

TKmlcFunctionMinimizer_Root::~TKmlcFunctionMinimizer_Root(void)
{
}

TKmlcFunctionMinimizer* TKmlcFunctionMinimizer_Root::Clone(void)
{
    return new TKmlcFunctionMinimizer_Root();
}

double TKmlcFunctionMinimizer_Root::Minimize(TKumaFunction& Function, TKumaPrimitiveVector& ValueList) throw(TKmlcException)
{
    TMinuit* Minuit = new TMinuit(ValueList.Size());

#ifdef VERBOSE
    Minuit->Command("SET PRINTOUT 1");
#else
    Minuit->Command("SET PRINTOUT -1");
    Minuit->Command("SET NOW");
#endif

    ObjectFunction = &Function;
    NumberOfParameters = ValueList.Size();

    Minuit->SetFCN(FCN);
    Minuit->SetErrorDef(1.0);

    double Step = 1.0;
    double LowerBound = 0;
    double UpperBound = 0;
    for (int Index = 0; Index < ValueList.Size(); Index++) {
        Minuit->DefineParameter(
	    Index, 
	    ValueList[Index].Name().c_str(), 
	    ValueList[Index].Value(), Step, 
	    LowerBound, UpperBound
	);
    }

    Minuit->Command("MINIMIZE");

#ifdef VERBOSE
    Minuit->Command("SHOW PARAMETER");
#endif

    double Value, Error;
    double* ParameterList = new double[ValueList.Size()];
    for (int Index = 0; Index < ValueList.Size(); Index++) {
	Minuit->GetParameter(Index, Value, Error);
	ValueList[Index].Value() = Value;
	ValueList[Index].Error() = Error;
	ParameterList[Index] = Value;
    }
    double FunctionValue = Function.ValueOf(ParameterList, ValueList.Size());
    delete[] ParameterList;

    delete Minuit;

    return FunctionValue;
}
