/* polynominal-fit-test.cc */
/* Created by Enomoto Sanshiro on 22 January 2001. */
/* Last updated by Enomoto Sanshiro on 22 January 2001. */


#include <cstdlib>
#include <iostream>
#include "KumaVector.hh"
#include "KumaPrimitive.hh"
#include "KmlcManager.hh"
#include "KmlcFunctionFitter.hh"

using namespace std;
using namespace kuma;


int main(int argc, char** argv) 
{
    int MaxOrder;
    if ((argc < 2) || ((MaxOrder = atoi(argv[1])) < 1)) {
	cerr << "usage: " << argv[0] << " MAX_ORDER" << endl;
	return -1;
    }
    
    double X, Y, Error;
    TKumaPrimitiveVector XDataList, YDataList;
    while (cin >> X >> Y >> Error) {
	XDataList.Add(TKumaPrimitive(X));
	YDataList.Add(TKumaPrimitive(Y, Error));
    }

    TKmlcFunctionMinimizer* Minimizer = 0;
    try {
	Minimizer = TKmlcManager::GetInstance()->CreateFunctionMinimizer();
    }
    catch (TKmlcException &e) {
	cerr << "ERROR: " << e << endl;
	return -1;
    }
    
    TKmlcFunctionFitter* FunctionFitter = new TKmlcFunctionFitter(Minimizer);
    TKumaPolynominalFunction Function(MaxOrder);

    int NumberOfParameters = Function.ParameterList().Size();
    int DigreeOfFreedom = XDataList.Size() - NumberOfParameters;
    double ChiSquared;
    try {
	ChiSquared = FunctionFitter->Fit(Function, XDataList, YDataList);
    }
    catch (TKmlcException &e) {
	cerr << "ERROR: "<< e << endl;
	return -1;
    }

    cout << endl;
    cout << "chi2/ndf: " << ChiSquared << "/" << DigreeOfFreedom << endl;
    for (int i = 0; i < NumberOfParameters; i++) {
	cout << "p" << i << ": ";
	cout << Function[i] << " +/- ";
	cout << Function[i].Error() << endl;
    }

    cout << endl;
    for (int j = 0; j < XDataList.Size(); j++) {
	double x = XDataList[j].Value();
	double y = YDataList[j].Value();
	cout << "f(" << x << ") = " << Function(x);
	cout << ", where data(" << x << ") = " << y << endl;
    }

    delete FunctionFitter;
    delete Minimizer;

    return 0;
}
