/* KorbNameServer.cc */
/* Created by Enomoto Sanshiro on 26 February 2000. */
/* Last updated by Enomoto Sanshiro on 26 February 2000. */


#include "KorbOrb.hh"
#include "KorbObjectAdapter.hh"
#include "KorbObjectMessenger.hh"
#include "KorbNamingContext.hh"
#include "KorbNameServer.hh"

using namespace std;



TKorbNameServer::TKorbNameServer(void)
{    
    int AdapterId = TKorbNamingContext::GetInitialReference().AdapterId();
    int ObjectId = TKorbNamingContext::GetInitialReference().ObjectId();

    _NamingContext = new TKorbNamingContext();	
    _Messenger = new TKorbNamingContextMessenger(_NamingContext);

    _Orb = new TKorbOrb(AdapterId);
    _ObjectAdapter = _Orb->ObjectAdapter();
    _ObjectAdapter->AddMessenger(_Messenger, "NamingContext", ObjectId);
}

TKorbNameServer::~TKorbNameServer() 
{
    delete _Orb;
    delete _Messenger;
    delete _NamingContext;
}

void TKorbNameServer::Start(void) throw(TKorbException)
{
    _ObjectAdapter->Start();
}
