/* KorbNamingContext.hh */
/* Created by Enomoto Sanshiro on 25 February 2000. */
/* Last updated by Enomoto Sanshiro on 5 April 2002. */


#ifndef __KorbNamingContext_hh__
#define __KorbNamingContext_hh__

#include <string>
#include <map>
#include "KorbOrb.hh"
#include "KorbObjectProxy.hh"
#include "KorbObjectMessenger.hh"


class TKorbNamingContext {
  public:
    TKorbNamingContext(void);
    virtual ~TKorbNamingContext();
    static TKorbObjectReference GetInitialReference(void);
    virtual void RegisterObject(const TKorbObjectReference& ObjectReference);
    virtual void UnregisterObject(const std::string& ObjectName);
    virtual int LookupObject(const std::string& ObjectName, TKorbObjectReference& ObjectReference);
    virtual int LookupService(const std::string& ClassName, TKorbObjectReference& ObjectReference);
  protected:
    std::map<std::string, TKorbObjectReference> _ObjectTable;
};


class TKorbNamingContextProxy: public TKorbObjectProxy, public TKorbNamingContext {
  public:
    TKorbNamingContextProxy(TKorbOrb* Orb);
    virtual ~TKorbNamingContextProxy();
    virtual void RegisterObject(const TKorbObjectReference& ObjectReference);
    virtual void UnregisterObject(const std::string& ObjectName);
    virtual int LookupObject(const std::string& ObjectName, TKorbObjectReference& ObjectReference);
    virtual int LookupService(const std::string& ClassName, TKorbObjectReference& ObjectReference);
};


class TKorbNamingContextMessenger: public TKorbObjectMessenger {
  public:
    enum TMethodId {
	MethodId_RegisterObject,
	MethodId_UnregisterObject,
	MethodId_LookupObject,
	MethodId_LookupService
    };
  public:
    TKorbNamingContextMessenger(TKorbNamingContext* NamingContext);
    virtual ~TKorbNamingContextMessenger();
    virtual int DispatchMethodInvocation(TKorbOrbPacket& OrbPacket) throw(TKorbException);
  protected:
    virtual int RegisterObject(TKorbOrbPacket& OrbPacket) throw(TKorbException);
    virtual int UnregisterObject(TKorbOrbPacket& OrbPacket) throw(TKorbException);
    virtual int LookupObject(TKorbOrbPacket& OrbPacket) throw(TKorbException);
    virtual int LookupService(TKorbOrbPacket& OrbPacket) throw(TKorbException);
  protected:
    TKorbNamingContext* _NamingContext;
};


#endif
