/* KorbOrbPacket.hh */
/* Created by Enomoto Sanshiro on 22 February 2000. */
/* Last updated by Enomoto Sanshiro on 22 February 2000. */


#ifndef __KorbOrbPacket_hh__
#define __KorbOrbPacket_hh__

#include <iostream>
#include "KorbNetworkPacket.hh"
#include "KorbSerializer.hh"


class TKorbOrbPacket {
  public:
    TKorbOrbPacket(TKorbNetworkPacket* NetworkPacket);
    TKorbOrbPacket(const TKorbOrbPacket& OrbPacket);
    TKorbOrbPacket& operator= (const TKorbOrbPacket& OrbPacket);
    virtual ~TKorbOrbPacket();
    virtual int& ObjectId(void);
    virtual int& MethodId(void);
    virtual int& IsOneWay(void);
    virtual int& RequestId(void);
    virtual int& IsRequest(void);
    virtual TKorbSerializer& ArgumentSerializer(void);
    virtual void Dump(std::ostream& os);
  protected:
    friend class TKorbOrb; 
    friend class TKorbObjectAdapter;
    friend class TKorbCommander;
    friend class TKorbBroker;
    virtual TKorbNetworkPacket* NetworkPacket(void);
    virtual void OnReceive(void);
    virtual void OnSend(void);
    virtual int PacketSize(void);
    virtual bool IsPacketValid(void);
  protected:
    int _ObjectId;
    int _MethodId;
    int _IsOneWay;
    int _RequestId;
    int _IsRequest;
    TKorbNetworkPacket* _NetworkPacket;
    TKorbSerializer _ArgumentSerializer;
};


#endif
